// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"
#include "mailbox_utils.h"
#include "ufm_rw_utils.h"
#include "ufm_utils.h"
#include "t0_provisioning.h"
#include "test_main.h"

static void ut_wait_ufm_command_done()
{
    while ((read_from_mailbox(MB_PROVISION_STATUS) & MB_UFM_PROV_CMD_DONE_MASK) == 0)
    {
    }
}

static void ut_exec_cmd(alt_u32 cmd)
{
    write_to_mailbox(MB_PROVISION_CMD, cmd);
    write_to_mailbox(MB_UFM_CMD_TRIGGER, 0x01);
    ut_wait_ufm_command_done();
}

static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_provisioning_flow()
{
    // key hash(example key from testdata)
    alt_u8 key_hash[32] = {0x6b, 0xa4, 0xa6, 0x98, 0x53, 0x63, 0xf0, 0xe7, 0xe9, 0x98, 0x76,
                           0x62, 0x7d, 0xe7, 0x12, 0x41, 0xda, 0xab, 0x4b, 0x96, 0xbd, 0x67,
                           0x99, 0x82, 0x81, 0x40, 0x27, 0x87, 0xa5, 0x10, 0x6e, 0x73};
    // active / recovery / staging
    alt_u8 pch_offsets[12] = {
        0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0xbf, 0x01, 0x00, 0x00, 0x7f, 0x00};
    alt_u8 bmc_offsets[12] = {
        0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xa0, 0x02, 0x00, 0x00, 0xa0, 0x04};

    // Provision Root Key Hash
    for (alt_u32 word_i = 0; word_i < 32; word_i++)
    {
        write_to_mailbox(MB_UFM_WRITE_FIFO, key_hash[word_i]);
    }

    ut_exec_cmd(0x01);
    mb_ufm_provisioning_handler();
    
    // Provision PCH offsets
    for (alt_u32 word_i = 0; word_i < 12; word_i++)
    {
        write_to_mailbox(MB_UFM_WRITE_FIFO, pch_offsets[word_i]);
    }
    ut_exec_cmd(0x05);
    mb_ufm_provisioning_handler();

    // Provision BMC offsets
    for (alt_u32 word_i = 0; word_i < 12; word_i++)
    {
        write_to_mailbox(MB_UFM_WRITE_FIFO, bmc_offsets[word_i]);
    }
    ut_exec_cmd(0x06);
    mb_ufm_provisioning_handler();

    if (is_ufm_locked())
    {
        return 0;
    }

    if (!is_ufm_provisioned())
    {
        return 0;
    }

    if (read_from_mailbox(MB_LAST_PANIC_REASON) != 0)
    {
        return 0;
    }
    if (read_from_mailbox(MB_PANIC_EVENT_COUNT) != 0)
    {
        return 0;
    }
    if (read_from_mailbox(MB_LAST_RECOVERY_REASON) != 0)
    {
        return 0;
    }
    if (read_from_mailbox(MB_RECOVERY_COUNT) != 0)
    {
        return 0;
    }
    if (read_from_mailbox(MB_MAJOR_ERROR_CODE) != 0)
    {
        return 0;
    }
    if (read_from_mailbox(MB_MINOR_ERROR_CODE) != 0)
    {
        return 0;
    }
    
    if ((read_from_mailbox(MB_PROVISION_STATUS) & MB_UFM_PROV_CMD_ERROR_MASK) != 0)
    {
        return 0;
    }

    return 1;
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    return test_provisioning_flow();
}