// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "spi_ctrl_utils.h"
#include "spi_rw_utils.h"
#include "test_main.h"


// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    configure_spi_master_csr();
    takeover_spi_ctrl(SPI_FLASH_PCH);

    // Make sure what we are reading isn't blank before doing the erase test
    alt_u32* spi_ptr = get_spi_flash_ptr_with_offset(0x1000);
    if (*spi_ptr != 0xFFFFFFFF)
    {
    	erase_4kb_in_spi_flash(0x1000);
    	return *spi_ptr == (alt_u32) 0xFFFFFFFF;
    }

    return 0;
}
