// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"

#include "spi_ctrl_utils.h"
#include "spi_rw_utils.h"
#include "test_main.h"


// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    configure_spi_master_csr();
    takeover_spi_ctrl(SPI_FLASH_PCH);

    alt_u32 write_word = 0xDEADBEEF;
    alt_u32 test_offset = 0x1B000;
    alt_u32* spi_flash_ptr = get_spi_flash_ptr_with_offset(test_offset);
    *spi_flash_ptr = write_word;
    if (*spi_flash_ptr != (alt_u32) write_word)
    {
        return 0;
    }

    write_word = 0x12345678;
    test_offset = 0xA37C00;
    spi_flash_ptr = get_spi_flash_ptr_with_offset(test_offset);
    *spi_flash_ptr = write_word;
    if (*spi_flash_ptr != (alt_u32) write_word)
    {
        return 0;
    }

    write_word = 0x89ABCDEF;
    test_offset = 0x2ff0000;
    spi_flash_ptr = get_spi_flash_ptr_with_offset(test_offset);
    *spi_flash_ptr = write_word;
    if (*spi_flash_ptr != (alt_u32) write_word)
    {
        return 0;
    }

    return 1;
}
