// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other
// software and tools, and its AMPP partner logic functions, and any output
// files from any of the foregoing (including device programming or simulation
// files), and any associated documentation or information are expressly subject
// to the terms and conditions of the Intel Program License Subscription
// Agreement, Intel FPGA IP License Agreement, or other applicable
// license agreement, including, without limitation, that your use is for the
// sole purpose of programming logic devices manufactured by Intel and sold by
// Intel or its authorized distributors.  Please refer to the applicable
// agreement for further details.

// Includes

// Always include pfr_sys first
#include "pfr_sys.h"
#include "gen_gpi_signals.h"
#include "gen_gpo_controls.h"
#include "mailbox_utils.h"
#include "t0_provisioning.h"
#include "t0_watchdog_handler.h"
#include "platform_log.h"
#include "test_main.h"

static PFR_ALT_INLINE alt_u32 PFR_ALT_ALWAYS_INLINE test_timed_boot_flow()
{

    // send checkpoint message to indicate BMC, ACM and BIOS boot done
    write_to_mailbox(MB_BMC_CHECKPOINT, MB_CHKPT_COMPLETE);
    write_to_mailbox(MB_ACM_CHECKPOINT, MB_CHKPT_COMPLETE);
    write_to_mailbox(MB_BIOS_CHECKPOINT, MB_CHKPT_COMPLETE);

    set_bit(WDT_ME_TIMER_ADDR, U_TIMER_BANK_TIMER_ACTIVE_BIT);
    set_bit(WDT_ACM_BIOS_TIMER_ADDR, U_TIMER_BANK_TIMER_ACTIVE_BIT);

    // initially nothing is boot
    wdt_boot_status = 0b00000;
    wdt_enable_status = WDT_ENABLE_ALL_TIMERS_MASK;

    alt_u32 count_ms = 2;
    start_timer_ms(U_TIMER_BANK_TIMER1_ADDR, count_ms);
    start_timer_ms(U_TIMER_BANK_TIMER2_ADDR, count_ms);
    start_timer_ms(U_TIMER_BANK_TIMER3_ADDR, count_ms);
    // first round BMC, ACM, ME boot
    watchdog_routine();

    // second round IBB boot
    write_to_mailbox(MB_BIOS_CHECKPOINT, MB_CHKPT_COMPLETE);
    watchdog_routine();

    // third round OBB boot
    write_to_mailbox(MB_BIOS_CHECKPOINT, MB_CHKPT_COMPLETE);
    watchdog_routine();

    return is_timed_boot_done();
}

// Test mainline. Return 0 on error or 1 to pass
int test_main()
{
    return test_timed_boot_flow();
}