#!/usr/bin/env python

import argparse
from argparse import RawTextHelpFormatter
from modules.pfr_bitstream import PFRBitstream
from modules.convert import Convert

# takes a single byte and returns a that byte reversed byte[7:0] -> byte[0:7]
def reverse_bits(byte):
        byte = (byte & 0xAA)>>1 | (byte & 0x55)<<1
        byte = (byte & 0xCC)>>2 | (byte & 0x33)<<2
        byte = (byte & 0xF0)>>4 | (byte & 0x0F)<<4
        return byte



parser = argparse.ArgumentParser(description='This tool generates the cpld update capsule before it is signed by the singing tool')
parser.add_argument('svn', metavar='svn', type=int, 
					help='The svn to be included in the CPLD update capsule. Value can range from 0 to 64, see HAS for details')
parser.add_argument('rpd_filename', metavar='rpd_filename', type=str, 
	        		help='the filename for the cmf0 rpd file, this file is an output from the compile flow')
parser.add_argument('output', metavar='output', type=str,
					help='The update capsule binary. This file is an input to the signing tool')
args = parser.parse_args()

try:
	rpd_file = open(args.rpd_filename, 'rb')
except IOError as e:
    print "File I/O error({0}): {1}".format(e.errno, e.strerror)
    raise

#convert svn to a byte array
#this funciton call has build in error checking
convert = Convert()
svn = convert.integer_to_bytes(args.svn, 4)

stream = PFRBitstream()
stream.initialize()

stream.append(svn)
stream.read(rpd_file)

#swap the endianness of the bytes
for i in range(4, stream.size(), 4):
	array = stream.get_raw_byte_array()
	array[i], array[i+1], array[i+2], array[i+3] = \
	array[i+3], array[i+2], array[i+1], array[i]

#reverse the bit order of each byte because we need to do this before writing the RPD into CFM
#skip svn in the first 4 bytes
for i in range(4, stream.size()):
	stream.get_raw_byte_array()[i] = reverse_bits(stream.get_raw_byte_array()[i])

output_file = open(args.output, 'wb')
stream.write(output_file)

rpd_file.close()
output_file.close()

