#!/usr/bin/env python

import argparse
from argparse import RawTextHelpFormatter

from modules.pfm_factory import PFMFactory

# Input Validations
parser = argparse.ArgumentParser(description='This tool generates sample pfm data binary blobs', formatter_class=RawTextHelpFormatter)
parser.add_argument('pfm_file', metavar='pfm_file', type=str,
                    help='a binary file containing PFM data')
args = parser.parse_args()

factory = PFMFactory()
pfm_obj = factory.generate_from_file(args.pfm_file)
if pfm_obj.validate():
    print "This PFM data passed legality check. "
