#!/usr/bin/env python

import argparse
from argparse import RawTextHelpFormatter

from modules.pfm_data import PFMData
from modules.pfm_spi_region import SPIRegionDef
from modules.pfm_smbus_rule import SMBusRuleDef
from modules.pfm_factory import PFMFactory

# Input Validations
parser = argparse.ArgumentParser(description='This tool generates sample pfm data binary blobs', formatter_class=RawTextHelpFormatter)
parser.add_argument('type', metavar='type', type=int,
                    help='0: PFM SPI region definition\n'
                         '1: PFM SMBus rule definition\n'
                         '2: simple PFM data with no SPI region or SMBus rule definitions\n'
                         '3: complex PFM data with SPI region and SMBus rule  definitions')
args = parser.parse_args()

pfm_obj = None
file_out = "pfm_data.bin"

# Sample PFM SPI region definition
region_def1 = SPIRegionDef()
region_def1.initialize()
region_def1.set_hash_algorithm(value=0b1)
region_def1.set_protection_mask(value=0b0001)
region_def1.set_start_addr(0x4000)
region_def1.set_end_addr(0x5C000)
region_def1.validate()

# Sample PFM SPI region definition
region_def2 = SPIRegionDef()
region_def2.initialize()
region_def2.set_hash_algorithm(value=0b0)
region_def2.set_protection_mask(value=0b0011)
region_def2.set_start_addr(0x5C000)
region_def2.set_end_addr(0x118000)
region_def2.validate()


# Sample PFM SPI region definition
region_def3 = SPIRegionDef()
region_def3.initialize()
region_def3.set_hash_algorithm(value=0b1)
region_def3.set_protection_mask(value=0b0001)
region_def3.set_start_addr(0x31C000)
region_def3.set_end_addr(0x430000)
region_def3.validate()

# Sample PFM SMBus rule definition
rule_def1 = SMBusRuleDef()
rule_def1.initialize()
rule_def1.set_bus_id(value=3)
rule_def1.set_rule_id(value=171)
rule_def1.set_device_addr(value=171)
rule_def1.set_cmd_whitelist(value=0b10101110011000101011)
rule_def1.validate()

# Sample PFM SMBus rule definition
rule_def2 = SMBusRuleDef()
rule_def2.initialize()
rule_def2.set_bus_id(value=3)
rule_def2.set_rule_id(value=171)
rule_def2.set_device_addr(value=171)
rule_def2.set_cmd_whitelist(value=0b10101110011000101011)
rule_def2.validate()

# Create/Set the PFM object
if args.type == 0:
    file_out = "pfm_spi_region.bin"
    pfm_obj = region_def1
elif args.type == 1:
    file_out = "pfm_smbus_rule.bin"
    pfm_obj = rule_def1
elif args.type == 2:
    pfm_obj = PFMData()
    pfm_obj.initialize()

    pfm_obj.set_revision(value=0x0101)
    pfm_obj.set_svn(value=0x03)
    pfm_obj.set_bkc_version(value=0x01)
    pfm_obj.set_padding()
    pfm_obj.validate()
elif args.type == 3:
    pfm_obj = PFMData()
    pfm_obj.initialize()

    pfm_obj.set_revision(value=0x0101)
    pfm_obj.set_svn(value=0x03)
    pfm_obj.set_bkc_version(value=0x01)

    pfm_obj.append_pfm_def(region_def1)
    pfm_obj.append_pfm_def(region_def2)
    pfm_obj.append_pfm_def(rule_def1)
    pfm_obj.append_pfm_def(region_def3)
    pfm_obj.append_pfm_def(rule_def2)

    pfm_obj.set_padding()
    pfm_obj.validate()
else:
    raise ValueError("Invalid type. Please check the help manual of this tool for more details. ")

# Save the PFM object to binary file
factory = PFMFactory()
factory.save_to_file(pfm_obj, file_out)

print "Successfully saved to " + file_out
