// Test headers
#include "bsp_mock.h"
#include "dual_config_mock.h"

// Constructor/Destructor
DUAL_CONFIG_MOCK::DUAL_CONFIG_MOCK() {}
DUAL_CONFIG_MOCK::~DUAL_CONFIG_MOCK() {}

// Class methods

void DUAL_CONFIG_MOCK::reset()
{
	m_dual_config.reset();
}

bool DUAL_CONFIG_MOCK::is_addr_in_range(void* addr)
{
    return m_dual_config.is_addr_in_range(addr);
}

alt_u32 DUAL_CONFIG_MOCK::get_mem_word(void* addr)
{
    if (m_dual_config.is_addr_in_range(addr))
    {
        return m_dual_config.get_mem_word(addr);
    }
    return 0;
}

void DUAL_CONFIG_MOCK::set_mem_word(void* addr, alt_u32 data)
{
    if (m_dual_config.is_addr_in_range(addr))
    {
    	m_dual_config.set_mem_word(addr, data);
    }
}
