
#ifndef SYSTEM_MAILBOX_MOCK_H
#define SYSTEM_MAILBOX_MOCK_H

// Standard headers
#include <memory>
#include <string>
#include <unordered_map>
#include <queue>

// Mock headers
#include "alt_types_mock.h"
#include "memory_mock.h"
#include "unordered_map_memory_mock.h"

// PFR system
#include "pfr_sys.h"

class MAILBOX_MOCK : public MEMORY_MOCK_IF
{
public:
    MAILBOX_MOCK();
    virtual ~MAILBOX_MOCK();

    void reset() override;

    alt_u32 get_mem_word(void* addr) override;
    void set_mem_word(void* addr, alt_u32 data) override;

    bool is_addr_in_range(void* addr) override;

private:
    // Memory area for SMBus Mailbox Register File
    UNORDERED_MAP_MEMORY_MOCK<U_MAILBOX_AVMM_BRIDGE_BASE, U_MAILBOX_AVMM_BRIDGE_SPAN>
        m_mailbox_reg_file;

    std::queue<alt_u8> m_fifo;
    void flush_fifo();
};

#endif /* SYSTEM_MAILBOX_MOCK_H_ */
