// Test headers
#include "bsp_mock.h"
#include "spi_control_mock.h"

// Code headers
#include "spi_common.h"

// Static data

// Type definitions

#define SPI_CONTROL_1_CSR_CS_FLASH_COMMAND_SETTING_ADDR \
    __IO_CALC_ADDRESS_NATIVE_ALT_U32(U_SPI_FILTER_CSR_AVMM_BRIDGE_0_BASE, SPI_CONTROL_1_CSR_CS_FLASH_COMMAND_SETTING_OFST)
#define SPI_CONTROL_1_CSR_CS_FLASH_COMMAND_ADDRESS_ADDR \
    __IO_CALC_ADDRESS_NATIVE_ALT_U32(U_SPI_FILTER_CSR_AVMM_BRIDGE_0_BASE, SPI_CONTROL_1_CSR_CS_FLASH_COMMAND_ADDRESS_OFST)

// Constructor/Destructor
SPI_CONTROL_MOCK::SPI_CONTROL_MOCK() {}
SPI_CONTROL_MOCK::~SPI_CONTROL_MOCK() {}

// Class methods

void SPI_CONTROL_MOCK::reset()
{
    m_bmc_we_mem.reset();
    m_pch_we_mem.reset();
    m_spi_master_csr.reset();
}

bool SPI_CONTROL_MOCK::is_addr_in_range(void* addr)
{
    return m_bmc_we_mem.is_addr_in_range(addr) || m_pch_we_mem.is_addr_in_range(addr) || m_spi_master_csr.is_addr_in_range(addr);
}

alt_u32 SPI_CONTROL_MOCK::get_mem_word(void* addr)
{
    if (m_bmc_we_mem.is_addr_in_range(addr))
    {
        return m_bmc_we_mem.get_mem_word(addr);
    }
    else if (m_pch_we_mem.is_addr_in_range(addr))
    {
        return m_pch_we_mem.get_mem_word(addr);
    }
    return m_spi_master_csr.get_mem_word(addr);
}

void SPI_CONTROL_MOCK::set_mem_word(void* addr, alt_u32 data)
{
    if (m_bmc_we_mem.is_addr_in_range(addr))
    {
        m_bmc_we_mem.set_mem_word(addr, data);
    }
    else if (m_pch_we_mem.is_addr_in_range(addr))
    {
        m_pch_we_mem.set_mem_word(addr, data);
    }
    // In CSR memory range
    m_spi_master_csr.set_mem_word(addr, data);
    std::uintptr_t addr_int = reinterpret_cast<std::uintptr_t>(addr);
    alt_u32 csr_offset = (addr_int - U_SPI_FILTER_CSR_AVMM_BRIDGE_0_BASE) >> 2;
    if (csr_offset == SPI_CONTROL_1_CSR_CS_FLASH_COMMAND_CONTROL_OFST)
    {
        if (data == 0x1)
        {
            // This triggers the SPI master IP to send command to the SPI device

            // Disabled this code for now. It was working until the support for two SPI flashes is added.
            // There's no way to get the BMC/PCH mux GPO bit value here.
//            // Only deal with the erase command for now
//            if (m_spi_master_csr.get_mem_word(SPI_CONTROL_1_CSR_CS_FLASH_COMMAND_SETTING_ADDR) == 0x0420)
//            {
//                alt_u32* spi_flash_ptr = spi_flash_mock_inst->get_flash_ptr();
//                alt_u32 erase_target_spi_address = m_spi_master_csr.get_mem_word(SPI_CONTROL_1_CSR_CS_FLASH_COMMAND_ADDRESS_ADDR);
//                spi_flash_ptr = spi_flash_ptr + (erase_target_spi_address >> 2);
//                // Erase the 4KB page at the target address
//                for (alt_u32 i = 0; i < (0x1000 >> 2); i++)
//                {
//                    spi_flash_ptr[i] = 0xffffffff;
//                }
//            }
        }
    }
}
