
#ifndef SYSTEM_SPI_CONTROL_MOCK_H
#define SYSTEM_SPI_CONTROL_MOCK_H

// Standard headers
#include <memory>
#include <string>
#include <unordered_map>
#include <queue>

// Mock headers
#include "alt_types_mock.h"
#include "memory_mock.h"
#include "unordered_map_memory_mock.h"

// PFR system
#include "pfr_sys.h"

class SPI_CONTROL_MOCK : public MEMORY_MOCK_IF
{
public:
    SPI_CONTROL_MOCK();
    virtual ~SPI_CONTROL_MOCK();

    void reset() override;

    alt_u32 get_mem_word(void* addr) override;
    void set_mem_word(void* addr, alt_u32 data) override;

    bool is_addr_in_range(void* addr) override;

private:
    // Memory area for SPI write enable memory
    UNORDERED_MAP_MEMORY_MOCK<U_SPI_FILTER_BMC_WE_AVMM_BRIDGE_BASE, U_SPI_FILTER_BMC_WE_AVMM_BRIDGE_SPAN> m_bmc_we_mem;
    UNORDERED_MAP_MEMORY_MOCK<U_SPI_FILTER_PCH_WE_AVMM_BRIDGE_BASE, U_SPI_FILTER_PCH_WE_AVMM_BRIDGE_SPAN> m_pch_we_mem;

    // Memory area for SPI CSR interface
    UNORDERED_MAP_MEMORY_MOCK<U_SPI_FILTER_CSR_AVMM_BRIDGE_0_BASE, U_SPI_FILTER_CSR_AVMM_BRIDGE_0_SPAN> m_spi_master_csr;

    // Instance of the SPI flash mock
    SPI_FLASH_MOCK* spi_flash_mock_inst = SPI_FLASH_MOCK::get();
};

#endif /* SYSTEM_SPI_CONTROL_MOCK_H */
