#ifndef INC_TESTDATA_FILES_H
#define INC_TESTDATA_FILES_H

/*
 * PFR Images for SPI flash
 */
#define FULL_PFR_IMAGE_BMC_FILE "testdata/full_pfr_image_bmc.bin"
#define FULL_PFR_IMAGE_BMC_FILE_SIZE 134217728
// Steps
// sha256sum testdata/full_pfr_image_bmc.bin
// echo "<insert hash here>" | xxd -r -p | xxd -i
const alt_u8 full_pfr_image_bmc_file_sha256sum[32] = {
    0x40, 0x81, 0xc6, 0x3d, 0x57, 0xc3, 0x1f, 0x45, 0x6a, 0xb3, 0xbd, 0xba,
    0x2b, 0x9b, 0xff, 0xa3, 0x94, 0x9d, 0xf1, 0xb9, 0x93, 0xab, 0x76, 0x8b,
    0x0b, 0x0e, 0xfa, 0x54, 0x4f, 0x4e, 0xbf, 0x29
};

#define FULL_PFR_IMAGE_PCH_FILE "testdata/full_pfr_image_pch.bin"
#define FULL_PFR_IMAGE_PCH_FILE_SIZE 67108864
const alt_u8 full_pfr_image_pch_file_sha256sum[32] = {
    0xa4, 0xae, 0xef, 0x6f, 0x2e, 0xf6, 0xd1, 0x93, 0xb6, 0x13, 0xaa, 0xfe,
    0xee, 0x60, 0x07, 0x1e, 0xdd, 0x36, 0x2c, 0xb9, 0x1b, 0x47, 0xe8, 0x0f,
    0xd8, 0xbb, 0x84, 0x3d, 0xaf, 0x1f, 0x65, 0xd8
};

#define GENERATED_FULL_PFR_IMAGE_BMC_WITH_STAGING_FILE \
    "testdata/generated_full_pfr_image_bmc_with_staging.bin"
#define GENERATED_FULL_PFR_IMAGE_BMC_WITH_STAGING_FILE_SIZE 134217728
/*
 * Signed firmware update capsule
 */
#define SIGNED_CAPSULE_BMC_FILE "testdata/signed_capsule_bmc.bin"
#define SIGNED_CAPSULE_BMC_FILE_SIZE 19552768

#define SIGNED_CAPSULE_PCH_FILE "testdata/signed_capsule_pch.bin"
#define SIGNED_CAPSULE_PCH_FILE_SIZE 10771072

/*
 * Signed PFM
 */
#define SIGNED_PFM_BMC_FILE "testdata/signed_pfm_bmc.bin"
#define SIGNED_PFM_BMC_FILE_SIZE 1408

#define SIGNED_PFM_BIOS_FILE "testdata/signed_pfm_pch.bin"
#define SIGNED_PFM_BIOS_FILE_SIZE 1408

/*
 * CPLD image & capsule
 */
#define CFM1_ACTIVE_IMAGE_FILE "testdata/cpld_cfm1_active_image.bin"
#define CFM1_ACTIVE_IMAGE_FILE_SIZE 270336

#define CFM0_RECOVERY_IMAGE_FILE "testdata/cpld_cfm0_recovery_image.bin"
#define CFM0_RECOVERY_IMAGE_FILE_SIZE 270336

#define SIGNED_CAPSULE_CPLD_FILE "testdata/signed_capsule_cpld.bin"
#define SIGNED_CAPSULE_CPLD_FILE_SIZE 271488

/*
 * Signed random binary
 */
#define SIGNED_BINARY_BLOCKSIGN_FILE "testdata/signed_binary_blocksign.bin"
#define SIGNED_BINARY_BLOCKSIGN_FILE_SIZE 1152

/*
 * UFM data for provisioning
 */
#define UFM_PFR_DATA_EXAMPLE_KEY_FILE "testdata/ufm_data_example_key.hex"

/*
 * Key cancellation certificate
 */
#define KEY_CAN_CERT_FILE_SIZE 1152

#define KEY_CAN_CERT_PCH_PFM_KEY2 "testdata/key_cancellation_certs/signed_pch_pfm_key2_can_cert.bin"
#define KEY_CAN_CERT_PCH_PFM_KEY255 "testdata/key_cancellation_certs/signed_pch_pfm_key255_can_cert.bin"

#define KEY_CAN_CERT_MODIFIED_RESERVED_AREA "testdata/key_cancellation_certs/signed_key_can_cert_modified_reserved_area.bin"
#define KEY_CAN_CERT_BAD_PCH_LEGNTH "testdata/key_cancellation_certs/signed_key_can_cert_bad_pc_length.bin"
#define KEY_CAN_CERT_BAD_PCH_LEGNTH_FILE_SIZE 1280

#define KEY_CAN_CERT_PCH_CAPSULE_KEY2 "testdata/key_cancellation_certs/signed_pch_capsule_key2_can_cert.bin"
#define KEY_CAN_CERT_PCH_CAPSULE_KEY10 "testdata/key_cancellation_certs/signed_pch_capsule_key10_can_cert.bin"

/*
 * Generated PFM
 */
#define GEN_256B_PFM_FILE "testdata/gen_256B_pfm.dat"
#define GEN_256B_PFM_FILE_SIZE 256

/*
 * BMC firmware update flow
 */

#define FULL_PFR_IMAGE_BMC_V14_FILE "testdata/bmc_firmware_update/full_pfr_image_bmc.bin"
#define FULL_PFR_IMAGE_BMC_V14_FILE_SIZE 134217728

#define SIGNED_CAPSULE_BMC_V14_FILE "testdata/bmc_firmware_update/signed_capsule_bmc.bin"
#define SIGNED_CAPSULE_BMC_V14_FILE_SIZE 19425792

/*
 * PCH firmware update flow
 */
#define FULL_PFR_IMAGE_PCH_13D08_FILE "testdata/pch_firmware_update/full_pfr_image_pch.bin"
#define FULL_PFR_IMAGE_PCH_13D08_FILE_SIZE 67108864

#define SIGNED_CAPSULE_PCH_13D08_FILE "testdata/pch_firmware_update/signed_capsule_pch.bin"
#define SIGNED_CAPSULE_PCH_13D08_FILE_SIZE 10766976

/*
 * Anti Rollback Tests
 */
#define SIGNED_CAPSULE_PCH_WITH_CSK_ID10_FILE "testdata/anti_rollback_with_csk_id/signed_capsule_pch_with_csk_id10.bin"
#define SIGNED_CAPSULE_PCH_WITH_CSK_ID10_FILE_SIZE 10771072

/*
 * PCH firmware update capsule with different SVNs
 */
#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN_255_FILE "testdata/bad_firmware_capsule/signed_capsule_pch_pfm_with_svn_0xFF.bin"
#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN_255_FILE_SIZE 10771072

#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN_65_FILE "testdata/bad_firmware_capsule/signed_capsule_pch_pfm_with_svn65.bin"
#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN_65_FILE_SIZE 10771072

#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN64_FILE "testdata/anti_rollback_with_svn/signed_capsule_pch_pfm_with_svn64.bin"
#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN64_FILE_SIZE 10771072

#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN9_FILE "testdata/anti_rollback_with_svn/signed_capsule_pch_pfm_with_svn9.bin"
#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN9_FILE_SIZE 10771072

#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN7_FILE "testdata/anti_rollback_with_svn/signed_capsule_pch_pfm_with_svn7.bin"
#define SIGNED_CAPSULE_PCH_PFM_WITH_SVN7_FILE_SIZE 10771072

#endif /* INC_TESTDATA_FILES_H_ */
