#ifndef INC_TESTDATA_INFO_H
#define INC_TESTDATA_INFO_H


/*
 * Important offsets in PCH image
 */
#define PCH_RECOVERY_REGION_ADDR 0x1bf0000

#define PCH_ACTIVE_PFM_SVN 0x0
#define PCH_ACTIVE_PFM_MAJOR_VER 0x0
#define PCH_ACTIVE_PFM_MINOR_VER 0x0

#define PCH_RECOVERY_PFM_SVN PCH_ACTIVE_PFM_SVN
#define PCH_RECOVERY_PFM_MAJOR_VER PCH_ACTIVE_PFM_MAJOR_VER
#define PCH_RECOVERY_PFM_MINOR_VER PCH_ACTIVE_PFM_MINOR_VER

#define PCH_UPDATE_CAPSULE_PFM_SVN PCH_ACTIVE_PFM_SVN
#define PCH_UPDATE_CAPSULE_PFM_MAJOR_VER PCH_ACTIVE_PFM_MAJOR_VER
#define PCH_UPDATE_CAPSULE_PFM_MINOR_VER PCH_ACTIVE_PFM_MINOR_VER

/*
 * PCH
 * SPI region offsets from the PFM in PCH update capsule
 *
 * Static SPI regions are: region 1/2/3/5/10
 * Dynamic SPI regions are:4/6/7/8/11
 */
#define PCH_SPI_REGION1_START_ADDR 0x0
#define PCH_SPI_REGION1_END_ADDR 0x1000

#define PCH_SPI_REGION2_START_ADDR 0x1000
#define PCH_SPI_REGION2_END_ADDR 0x3000

#define PCH_SPI_REGION3_START_ADDR 0x3000
#define PCH_SPI_REGION3_END_ADDR 0x28000

#define PCH_SPI_REGION4_START_ADDR 0x28000
#define PCH_SPI_REGION4_END_ADDR 0xbf000

#define PCH_SPI_REGION5_START_ADDR 0xbf000
#define PCH_SPI_REGION5_END_ADDR 0x7b8000

#define PCH_SPI_REGION6_START_ADDR 0x7b8000
#define PCH_SPI_REGION6_END_ADDR 0x7c8000

#define PCH_SPI_REGION7_START_ADDR 0x7c8000
#define PCH_SPI_REGION7_END_ADDR 0x7e0000

#define PCH_SPI_REGION8_START_ADDR 0x7e0000
#define PCH_SPI_REGION8_END_ADDR 0x7f0000

#define PCH_SPI_REGION9_START_ADDR 0x7f0000
#define PCH_SPI_REGION9_END_ADDR 0x03000000

#define PCH_SPI_REGION10_START_ADDR 0x03000000
#define PCH_SPI_REGION10_END_ADDR 0x03240000

#define PCH_SPI_REGION11_START_ADDR 0x03240000
#define PCH_SPI_REGION11_END_ADDR 0x04000000

#define PCH_NUM_SPI_REGIONS 11
const alt_u32 testdata_pch_spi_regions_start_addr[PCH_NUM_SPI_REGIONS] = {
        PCH_SPI_REGION1_START_ADDR, PCH_SPI_REGION2_START_ADDR, PCH_SPI_REGION3_START_ADDR,
        PCH_SPI_REGION4_START_ADDR, PCH_SPI_REGION5_START_ADDR, PCH_SPI_REGION6_START_ADDR,
        PCH_SPI_REGION7_START_ADDR, PCH_SPI_REGION8_START_ADDR, PCH_SPI_REGION9_START_ADDR,
        PCH_SPI_REGION10_START_ADDR, PCH_SPI_REGION11_START_ADDR
};
const alt_u32 testdata_pch_spi_regions_end_addr[PCH_NUM_SPI_REGIONS] = {
        PCH_SPI_REGION1_END_ADDR, PCH_SPI_REGION2_END_ADDR, PCH_SPI_REGION3_END_ADDR,
        PCH_SPI_REGION4_END_ADDR, PCH_SPI_REGION5_END_ADDR, PCH_SPI_REGION6_END_ADDR,
        PCH_SPI_REGION7_END_ADDR, PCH_SPI_REGION8_END_ADDR, PCH_SPI_REGION9_END_ADDR,
        PCH_SPI_REGION10_END_ADDR, PCH_SPI_REGION11_END_ADDR
};

#define PCH_NUM_STATIC_REGIONS 5
const alt_u32 testdata_pch_static_regions_start_addr[PCH_NUM_STATIC_REGIONS] = {
        PCH_SPI_REGION1_START_ADDR, PCH_SPI_REGION2_START_ADDR, PCH_SPI_REGION3_START_ADDR,
        PCH_SPI_REGION5_START_ADDR, PCH_SPI_REGION10_START_ADDR
};
const alt_u32 testdata_pch_static_regions_end_addr[PCH_NUM_STATIC_REGIONS] = {
        PCH_SPI_REGION1_END_ADDR, PCH_SPI_REGION2_END_ADDR, PCH_SPI_REGION3_END_ADDR,
        PCH_SPI_REGION5_END_ADDR, PCH_SPI_REGION10_END_ADDR
};

#define PCH_NUM_DYNAMIC_REGIONS 5
const alt_u32 testdata_pch_dynamic_regions_start_addr[PCH_NUM_DYNAMIC_REGIONS] = {
        PCH_SPI_REGION4_START_ADDR, PCH_SPI_REGION6_START_ADDR, PCH_SPI_REGION7_START_ADDR,
        PCH_SPI_REGION8_START_ADDR, PCH_SPI_REGION11_START_ADDR
};

const alt_u32 testdata_pch_dynamic_regions_end_addr[PCH_NUM_DYNAMIC_REGIONS] = {
        PCH_SPI_REGION4_END_ADDR, PCH_SPI_REGION6_END_ADDR, PCH_SPI_REGION7_END_ADDR,
        PCH_SPI_REGION8_END_ADDR, PCH_SPI_REGION11_END_ADDR
};

/*
 * Important offsets in BMC image
 */
#define BMC_RECOVERY_REGION_ADDR 0x2a00000

#define BMC_ACTIVE_PFM_SVN 0x01
#define BMC_ACTIVE_PFM_MAJOR_VER 0x0
#define BMC_ACTIVE_PFM_MINOR_VER 17

#define BMC_RECOVERY_PFM_SVN BMC_ACTIVE_PFM_SVN
#define BMC_RECOVERY_PFM_MAJOR_VER BMC_ACTIVE_PFM_MAJOR_VER
#define BMC_RECOVERY_PFM_MINOR_VER BMC_ACTIVE_PFM_MINOR_VER

#define BMC_UPDATE_CAPSULE_PFM_SVN BMC_ACTIVE_PFM_SVN
#define BMC_UPDATE_CAPSULE_PFM_MAJOR_VER BMC_ACTIVE_PFM_MAJOR_VER
#define BMC_UPDATE_CAPSULE_PFM_MINOR_VER BMC_ACTIVE_PFM_MINOR_VER

/*
 * BMC
 * SPI region offsets from the PFM in BMC update capsule
 *
 * Static SPI regions are: region 1, 6
 * Dynamic SPI regions are: 3, 4, 5
 * Region 8 is writable but not recoverable
 */
#define BMC_SPI_REGION1_START_ADDR 0x0
#define BMC_SPI_REGION1_START_WORD_OFST (BMC_SPI_REGION1_START_ADDR >> 2)
#define BMC_SPI_REGION1_END_ADDR 0x80000
#define BMC_SPI_REGION1_END_WORD_OFST (BMC_SPI_REGION1_END_ADDR >> 2)

#define BMC_SPI_REGION2_START_ADDR 0x80000
#define BMC_SPI_REGION2_START_WORD_OFST (BMC_SPI_REGION2_START_ADDR >> 2)
#define BMC_SPI_REGION2_END_ADDR 0xa0000
#define BMC_SPI_REGION2_END_WORD_OFST (BMC_SPI_REGION2_END_ADDR >> 2)

#define BMC_SPI_REGION3_START_ADDR 0xa0000
#define BMC_SPI_REGION3_START_WORD_OFST (BMC_SPI_REGION2_START_ADDR >> 2)
#define BMC_SPI_REGION3_END_ADDR 0xc0000
#define BMC_SPI_REGION3_END_WORD_OFST (BMC_SPI_REGION2_END_ADDR >> 2)

#define BMC_SPI_REGION4_START_ADDR 0xc0000
#define BMC_SPI_REGION4_START_WORD_OFST (BMC_SPI_REGION3_START_ADDR >> 2)
#define BMC_SPI_REGION4_END_ADDR 0x2c0000
#define BMC_SPI_REGION4_END_WORD_OFST (BMC_SPI_REGION3_END_ADDR >> 2)

#define BMC_SPI_REGION5_START_ADDR 0x2c0000
#define BMC_SPI_REGION5_START_WORD_OFST (BMC_SPI_REGION4_START_ADDR >> 2)
#define BMC_SPI_REGION5_END_ADDR 0xb00000
#define BMC_SPI_REGION5_END_WORD_OFST (BMC_SPI_REGION4_END_ADDR >> 2)

#define BMC_SPI_REGION6_START_ADDR 0xb00000
#define BMC_SPI_REGION6_START_WORD_OFST (BMC_SPI_REGION5_START_ADDR >> 2)
#define BMC_SPI_REGION6_END_ADDR 0x2a00000
#define BMC_SPI_REGION6_END_WORD_OFST (BMC_SPI_REGION5_END_ADDR >> 2)

#define BMC_SPI_REGION7_START_ADDR 0x2a00000
#define BMC_SPI_REGION7_START_WORD_OFST (BMC_SPI_REGION7_START_ADDR >> 2)
#define BMC_SPI_REGION7_END_ADDR 0x4a00000
#define BMC_SPI_REGION7_END_WORD_OFST (BMC_SPI_REGION7_END_ADDR >> 2)

#define BMC_SPI_REGION8_START_ADDR 0x4a00000
#define BMC_SPI_REGION8_START_WORD_OFST (BMC_SPI_REGION8_START_ADDR >> 2)
#define BMC_SPI_REGION8_END_ADDR 0x8000000
#define BMC_SPI_REGION8_END_WORD_OFST (BMC_SPI_REGION8_END_ADDR >> 2)

#define BMC_NUM_SPI_REGIONS 8
const alt_u32 testdata_bmc_spi_regions_start_addr[BMC_NUM_SPI_REGIONS] = {
        BMC_SPI_REGION1_START_ADDR, BMC_SPI_REGION2_START_ADDR, BMC_SPI_REGION3_START_ADDR,
        BMC_SPI_REGION4_START_ADDR, BMC_SPI_REGION5_START_ADDR, BMC_SPI_REGION6_START_ADDR,
        BMC_SPI_REGION7_START_ADDR, BMC_SPI_REGION8_START_ADDR
};

const alt_u32 testdata_bmc_spi_regions_end_addr[BMC_NUM_SPI_REGIONS] = {
        BMC_SPI_REGION1_END_ADDR, BMC_SPI_REGION2_END_ADDR, BMC_SPI_REGION3_END_ADDR,
        BMC_SPI_REGION4_END_ADDR, BMC_SPI_REGION5_END_ADDR, BMC_SPI_REGION6_END_ADDR,
        BMC_SPI_REGION7_END_ADDR, BMC_SPI_REGION8_END_ADDR
};

#define BMC_NUM_STATIC_REGIONS 2
const alt_u32 testdata_bmc_static_regions_start_addr[BMC_NUM_STATIC_REGIONS] = {
        BMC_SPI_REGION1_START_ADDR, BMC_SPI_REGION6_START_ADDR,
};

const alt_u32 testdata_bmc_static_regions_end_addr[BMC_NUM_STATIC_REGIONS] = {
        BMC_SPI_REGION1_END_ADDR, BMC_SPI_REGION6_END_ADDR,
};

#define BMC_NUM_DYNAMIC_REGIONS 3
const alt_u32 testdata_bmc_dynamic_regions_start_addr[BMC_NUM_DYNAMIC_REGIONS] = {
        BMC_SPI_REGION3_START_ADDR, BMC_SPI_REGION4_START_ADDR, BMC_SPI_REGION5_START_ADDR,
};

const alt_u32 testdata_bmc_dynamic_regions_end_addr[BMC_NUM_DYNAMIC_REGIONS] = {
        BMC_SPI_REGION3_END_ADDR, BMC_SPI_REGION4_END_ADDR, BMC_SPI_REGION5_END_ADDR,
};

#endif /* INC_TESTDATA_INFO_H */
