#ifndef SYSTEM_UFM_MOCK_H
#define SYSTEM_UFM_MOCK_H

// Standard headers
#include <memory>
#include <string>
#include <unordered_map>
#include <fstream>
#include <string.h>

// Mock headers
#include "alt_types_mock.h"
#include "memory_mock.h"
#include "unordered_map_memory_mock.h"

// PFR system
#include "pfr_sys.h"
#include "ufm.h"


class UFM_MOCK
{
public:
    static UFM_MOCK* get();

    void reset();

    // Expose the x86 addresses of the flash memory
    alt_u32* get_flash_ptr() { return m_flash_mem; }

    void erase_page(alt_u32 addr)
    {
        alt_u32* page_start = m_flash_mem + ((addr / UFM_FLASH_PAGE_SIZE) * UFM_FLASH_PAGE_SIZE) / 4;
        std::fill(page_start, page_start + (UFM_FLASH_PAGE_SIZE / 4), 0xffffffff);
    }

    void write_page(alt_u32 addr, alt_u32* data, alt_u32 nbytes)
    {
        memcpy(m_flash_mem, data, nbytes);
    }

private:
    // Singleton inst
    static UFM_MOCK* s_inst;

    UFM_MOCK();
    ~UFM_MOCK();

    // Memory area for the flash memory
    alt_u32 *m_flash_mem = nullptr;
};

#endif /* SYSTEM_UFM_MOCK_H */
