#include <iostream>

// Include the GTest headers
#include "gtest_headers.h"

// Include the SYSTEM MOCK and PFR headers
#include "ut_nios_wrapper.h"

class AuthenticationTest : public testing::Test
{
public:
    virtual void SetUp()
    {
        SYSTEM_MOCK::get()->reset();

        // Provision the system (e.g. root key hash)
        SYSTEM_MOCK::get()->provision_ufm_data(UFM_PFR_DATA_EXAMPLE_KEY_FILE);
    }

    virtual void TearDown() {}
};


TEST_F(AuthenticationTest, test_authenticate_signed_pfm_bmc)
{
    // Load signed pfm from BMC team to memory
    alt_u8 signed_pfm_bmc[SIGNED_PFM_BMC_FILE_SIZE];
    SYSTEM_MOCK::get()->init_x86_mem_from_dat(SIGNED_PFM_BMC_FILE, (alt_u32*) signed_pfm_bmc);

    EXPECT_TRUE(is_signature_valid((KCH_SIGNATURE*) signed_pfm_bmc));
}

TEST_F(AuthenticationTest, test_authenticate_signed_pfm_pch)
{
    // Load signed pfm from PCH team to memory
    alt_u8 signed_pfm_bios[SIGNED_PFM_BIOS_FILE_SIZE];
    SYSTEM_MOCK::get()->init_x86_mem_from_dat(SIGNED_PFM_BIOS_FILE, (alt_u32*) signed_pfm_bios);

    EXPECT_TRUE(is_signature_valid((KCH_SIGNATURE*) signed_pfm_bios));
}

TEST_F(AuthenticationTest, test_authenticate_blocksign_signed_binary)
{
    // Load Blocksign tool signed payload to memory
    alt_u8 signed_binary_blocksign[SIGNED_BINARY_BLOCKSIGN_FILE_SIZE];
    SYSTEM_MOCK::get()->init_x86_mem_from_dat(SIGNED_BINARY_BLOCKSIGN_FILE, (alt_u32*) signed_binary_blocksign);

    EXPECT_TRUE(is_signature_valid((KCH_SIGNATURE*) signed_binary_blocksign));
}

TEST_F(AuthenticationTest, test_authenticate_cpld_update_signed_binary)
{
    // Load Blocksign tool signed payload to memory
    alt_u8 signed_binary_cpld_update[SIGNED_CAPSULE_CPLD_FILE_SIZE];
    SYSTEM_MOCK::get()->init_x86_mem_from_dat(SIGNED_CAPSULE_CPLD_FILE, (alt_u32*) signed_binary_cpld_update);

    EXPECT_TRUE(is_signature_valid((KCH_SIGNATURE*) signed_binary_cpld_update));
}

TEST_F(AuthenticationTest, test_authenticate_signed_key_cancellation_certificate)
{
    // Load an example key cancellation certificate to memory
    alt_u8 signed_cert[KEY_CAN_CERT_FILE_SIZE];
    SYSTEM_MOCK::get()->init_x86_mem_from_dat(KEY_CAN_CERT_PCH_PFM_KEY2, (alt_u32*) signed_cert);

    EXPECT_TRUE(is_signature_valid((KCH_SIGNATURE*) signed_cert));
}
