#include <iostream>

// Include the GTest headers
#include "gtest_headers.h"

// Include the SYSTEM MOCK and PFR headers
#include "ut_nios_wrapper.h"

class NiosFWInitializationTest : public testing::Test
{
public:
    virtual void SetUp()
    {
        SYSTEM_MOCK::get()->reset();
    }

    virtual void TearDown() {}
};

TEST_F(NiosFWInitializationTest, test_cpld_hash)
{
    /*
     * Run Nios FW to T-1 in unprovisioned state.
     */
    ut_allow_nios_to_start();

    // Insert the T0_OPERATIONS code block (break out of T0 loop)
    SYSTEM_MOCK::get()->insert_code_block(SYSTEM_MOCK::CODE_BLOCK_TYPES::T0_OPERATIONS);

    // Load active CPLD image to CFM1
    SYSTEM_MOCK::get()->load_active_image_to_cfm1();

    // Run PFR Main. Always run with the timeout
    ASSERT_DURATION_LE(1, pfr_main());

    /*
     * Check if CPLD hash is reported correctly to the mailbox.
     */
    alt_u8 expected_cpld_hash[PFR_CRYPTO_LENGTH] = {
            0x86, 0x55, 0xc1, 0xee, 0x4a, 0x14, 0xdc, 0xf2, 0x93, 0x46, 0xa5, 0x1d,
            0xe4, 0xc6, 0x95, 0x18, 0xfb, 0xb5, 0x65, 0x91, 0x2d, 0xd3, 0x13, 0x3a,
            0xb5, 0x23, 0xc6, 0x15, 0xf7, 0xe5, 0x8b, 0xf2
    };

    for (alt_u32 byte_i = 0; byte_i < PFR_CRYPTO_LENGTH; byte_i++)
    {
        EXPECT_EQ(IORD(U_MAILBOX_AVMM_BRIDGE_BASE, MB_CPLD_HASH + byte_i), expected_cpld_hash[byte_i]);
    }
}
