// Unit test for the PFR system flows

// Include the GTest headers
#include "gtest_headers.h"

// Include the SYSTEM MOCK and PFR headers
#include "ut_nios_wrapper.h"

class PFRTimedBootTest : public testing::Test
{
public:
    virtual void SetUp() {
        SYSTEM_MOCK::get()->reset();
        // Provision UFM data
        SYSTEM_MOCK::get()->provision_ufm_data(UFM_PFR_DATA_EXAMPLE_KEY_FILE);
        // Skip all T-1 operations
        SYSTEM_MOCK::get()->insert_code_block(SYSTEM_MOCK::CODE_BLOCK_TYPES::SKIP_TMIN1_OPERATIONS);

        // Reset Nios firmware
        ut_reset_nios_fw();
    }

    virtual void TearDown() {}
};

TEST_F(PFRTimedBootTest, test_simple_timed_boot_flow)
{
    // Timed boot is only enabled in provisioned state.
    EXPECT_TRUE(is_ufm_provisioned());

    ut_set_gpi_nios_start_and_me_boot_done();

    // Insert the T0_TIMED_BOOT code block (break out of T0 loop when all timer has stopped)
    SYSTEM_MOCK::get()->insert_code_block(SYSTEM_MOCK::CODE_BLOCK_TYPES::T0_TIMED_BOOT);

    ut_send_block_complete_chkpt_msg();

    // Run PFR Main. Always run with the timeout
    ASSERT_DURATION_LE(1, pfr_main());

    // Check observed vs expected global_state
    EXPECT_EQ(ut_get_global_state(), (alt_u32) PLATFORM_STATE_T0_BOOT_COMPLETE);
}

// TODO: This test is flaky. Remove it for now.
//TEST_F(PFRTimedBootTest, test_complex_timed_boot_flow)
//{
//    // Timed boot is only enabled in provisioned state.
//    EXPECT_TRUE(is_ufm_provisioned());
//
//    // Have the check on the Nios ready bit return true after 1 check
//    SYSTEM_MOCK::get()->register_read_write_callback(
//            [](SYSTEM_MOCK::READ_OR_WRITE read_or_write, void* addr, alt_u32 data) {
//        if (read_or_write == SYSTEM_MOCK::READ_OR_WRITE::READ && addr == U_GPI_1_ADDR)
//        {
//            // De-assert both PCH and BMC resets
//            SYSTEM_MOCK::get()->set_mem_word(U_GPI_1_ADDR, alt_u32(11), true);
//        }
//    });
//
//    // Insert the T0_TIMED_BOOT code block (break out of T0 loop when all timer has stopped)
//    SYSTEM_MOCK::get()->insert_code_block(SYSTEM_MOCK::CODE_BLOCK_TYPES::T0_TIMED_BOOT);
//
//    // Background thread that writes "Boot Done" signals to platform checkpoints
//    std::thread boot_thread([]() {
//        // Wait for BMC reset
//        while ((SYSTEM_MOCK::get()->get_mem_word(U_GPO_1_ADDR) & 0x01) == 0) {}
//
//        std::this_thread::sleep_for(std::chrono::milliseconds(30));
//
//        // Check observed vs expected global_state
//        alt_u32 g_state = ut_get_global_state();
//        EXPECT_TRUE(g_state & (alt_u32) GLOBAL_STATE_NIOS_ENTER_T0);
//
//        // BMC booted
//        alt_u32* bmc_ckpt_addr = U_MAILBOX_AVMM_BRIDGE_ADDR + MB_BMC_CHECKPOINT;
//        SYSTEM_MOCK::get()->set_mem_word(bmc_ckpt_addr, MB_CHKPT_COMPLETE, true);
//
//        // Check observed vs expected global_state
//        g_state = ut_get_global_state();
//        EXPECT_TRUE(g_state & (alt_u32) GLOBAL_STATE_NIOS_ENTER_T0);
//
//        std::this_thread::sleep_for(std::chrono::milliseconds(1));
//        // ACM booted after 1 ms
//        alt_u32* acm_ckpt_addr = U_MAILBOX_AVMM_BRIDGE_ADDR + MB_ACM_CHECKPOINT;
//        SYSTEM_MOCK::get()->set_mem_word(acm_ckpt_addr, MB_CHKPT_COMPLETE, true);
//
//        std::this_thread::sleep_for(std::chrono::milliseconds(1));
//        // BIOS booted after 1 ms
//        alt_u32* bios_ckpt_addr = U_MAILBOX_AVMM_BRIDGE_ADDR + MB_BIOS_CHECKPOINT;
//        SYSTEM_MOCK::get()->set_mem_word(bios_ckpt_addr, MB_CHKPT_COMPLETE, true);
//    });
//
//    // Run PFR Main. Always run with the timeout
//    ASSERT_DURATION_LE(1, pfr_main());
//
//    // Signaling should be done by now.
//    // Wait for the thread if something unexpected happens.
//    boot_thread.join();
//
//    // Check observed vs expected global_state
//    EXPECT_EQ(ut_get_global_state(), (alt_u32) GLOBAL_STATE_NIOS_T0_TIMED_BOOT_COMPLETE);
//}
