// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module Bmc_Seq
(
	input			iClk,//%Clock input
	input			iRst_n,//%Reset enable on high
	input 			i1mSCE, //% 1 mS Clock Enable
	input           iGoOutFltSt,//% Go out fault state.

	input 			PWRGD_P1V1_BMC_AUX,//% BMC VR PWRGD P1V1
	input 			PWRGD_P3V3_AUX,//% P3V3_AUX VR PWRGD
	input 			PWRGD_PCH_P1V8,//% PCH VR Enable P1V8
	input           FM_SLP_SUS_N,//% SLP_SUS

	input 			RST_DEDI_BUSY_PLD_N, //% Dediprog Detection Support 

	output reg		FM_BMC_P2V5_AUX_EN,//% BMC VR Enable P2V5
	output reg      RST_SRST_BMC_N , //% SRST# 
    output reg      oBmcPwrgd,//% PWRGD of all BMC VR's 

    output reg      oBmcPwrFlt//% Fault BMC VR's

);
//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////

	parameter  LOW =1'b0;
	parameter  HIGH=1'b1;

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
	wire wPwrgd_All_VRs_dly_2m;
	wire wPSLP_SUS_dly_1m;
	reg  rFM_SLP_SUS_RSM_RST_N_FF1, rSLP_SUS_N_Fall;
	reg  rPwrgdBmcP1V1_ff1;
	reg  rBmcPwrFltP1V1;


//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////

always @ ( posedge iClk) 
	begin 
		if (  !iRst_n  )   
			begin
				rFM_SLP_SUS_RSM_RST_N_FF1       <= HIGH;
				oBmcPwrFlt                      <= LOW;					
				rSLP_SUS_N_Fall                 <= LOW;	

				oBmcPwrgd                       <= LOW;	

				FM_BMC_P2V5_AUX_EN              <= LOW;	

				RST_SRST_BMC_N                  <= LOW;

				rPwrgdBmcP1V1_ff1               <= LOW;
				rBmcPwrFltP1V1                  <= LOW;
			end 
		else if ( iGoOutFltSt )
			begin				
				oBmcPwrFlt                      <= LOW;
				rBmcPwrFltP1V1                  <= LOW;
			end
		else 
			begin	
				oBmcPwrFlt                      <= (PWRGD_P3V3_AUX && (rBmcPwrFltP1V1)) ? HIGH: oBmcPwrFlt;  //detect BMC VR fault 		
				rFM_SLP_SUS_RSM_RST_N_FF1       <= FM_SLP_SUS_N;
				rSLP_SUS_N_Fall                 <= ~FM_SLP_SUS_N && rFM_SLP_SUS_RSM_RST_N_FF1;

				oBmcPwrgd                       <= PWRGD_P1V1_BMC_AUX; // last VR for BMC are ready.
				FM_BMC_P2V5_AUX_EN              <= (PWRGD_P3V3_AUX && PWRGD_PCH_P1V8 && (wPSLP_SUS_dly_1m));
				rPwrgdBmcP1V1_ff1               <= PWRGD_P1V1_BMC_AUX;

				rBmcPwrFltP1V1                  <= (FM_BMC_P2V5_AUX_EN && !PWRGD_P1V1_BMC_AUX && rPwrgdBmcP1V1_ff1) ? HIGH: rBmcPwrFltP1V1;
				
				RST_SRST_BMC_N                  <= (rSLP_SUS_N_Fall && oBmcPwrgd) ? LOW : (wPwrgd_All_VRs_dly_2m && RST_DEDI_BUSY_PLD_N);// The RST need be enable before of turn off the BMC								
			end
	end  



//////////////////////////////////////////////////////////////////////
// Instances 
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
//% 2ms Delay for power UP  RST_SRST_BMC_N
//
SignalValidationDelay#
(
    .VALUE                  ( 1'b1 ),
    .TOTAL_BITS             ( 2'd2 ),
    .POL                    ( 1'b1 )
)mRST_SRST_BMC_N
(           
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .iCE                    ( i1mSCE ),
    .ivMaxCnt               ( 2'd2 ),        //2ms delay
    .iStart                 ( oBmcPwrgd ),
    .oDone                  ( wPwrgd_All_VRs_dly_2m )
);

//% 1ms Delay for power down  FM_SLP_SUS_N
//
SignalValidationDelay#
(
    .VALUE                  ( 1'b0 ),
    .TOTAL_BITS             ( 1'd1 ),
    .POL                    ( 1'b0 )
)mSLP_SUS
(           
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .iCE                    ( i1mSCE ),
    .ivMaxCnt               ( 1'd1 ),        //1ms delay
    .iStart                 ( FM_SLP_SUS_N ),
    .oDone                  ( wPSLP_SUS_dly_1m )
);

endmodule
