// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module ClockLogic
(
	input			iClk,//%Clock input
	input			iRst_n,//%Reset enable on high
		
	input           iMainVRPwrgd,//% PWRGD of Main VR's from MainVR_Seq.v module
	input           iMCP_EN_CLK,	//%MCP Clock Enable 1
	input           PWRGD_PCH_PWROK,//%PCH PWROK from PCH

	output  reg     FM_PLD_CLKS_OE_N,	//%OE# enable if iMainVRPwrgd && PWRGD_PCH_PWROK = 1, OE# is asserted.
	output  reg     FM_CPU_BCLK5_OE_N	//%OE# enable if iMainVRPwrgd && PWRGD_PCH_PWROK = 1, OE# is asserted.
);

//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////
parameter  LOW =1'b0;
parameter  HIGH=1'b1;

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////
always @ ( posedge iClk) 
begin 
	if (  !iRst_n  )   
	begin
		FM_PLD_CLKS_OE_N       		<= HIGH;
		FM_CPU_BCLK5_OE_N			<= HIGH;
	end
	else 
	begin
		FM_CPU_BCLK5_OE_N   		<=  !(PWRGD_PCH_PWROK && iMainVRPwrgd && iMCP_EN_CLK);
		FM_PLD_CLKS_OE_N       		<=  !(iMainVRPwrgd && PWRGD_PCH_PWROK);				
	end
end  


//////////////////////////////////////////////////////////////////////
// Instances 
//////////////////////////////////////////////////////////////////////


endmodule
