// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module GSX_Master #(parameter TOTAL_OUTPUT_MODULES = 3)
(
	input 			iClk,			//% 2MHz Reference Clock
	input 			iCE,			//% Chip enable to generate oSClock. 10uS to generate 100KHz SClock
	input 		    iReset,			//%	Input reset.

	output 			oSClock,		//%	Output clock.
	output reg		oSLoad,			//%	Output Last clock of a bit stream; begin a new bit stream on the next clock.
	output reg		oSDataOut,		//%	Input serial data bit stream.
	input           iSDataIn, 		//%	Output serial data bit stream.

	output reg		[(TOTAL_OUTPUT_MODULES*8)-1:0]  ovDataIn, 		//% Data receive vector. Master receives using DataIn
	input   		[(TOTAL_OUTPUT_MODULES*8)-1:0]  ivDataOut 		//% Data transmit vector. Master transmits using DataOut
);
//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
reg [7:0] rCounter_Out;
wire wSClock;

//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////
//Idle SGPIO bus by driving signals HIGH when system is in Reset state
assign oSClock	= (!iReset) ? 1'b1 : wSClock;


//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @ (posedge wSClock) 	
begin 
	if(!iReset) 
	begin
		oSLoad    		<= 1'b1;
		oSDataOut 		<= 1'b1;
		rCounter_Out  	<= 8'd0;
	end
	else
	begin
		oSDataOut <= ivDataOut[rCounter_Out];				

		if( rCounter_Out == ((TOTAL_OUTPUT_MODULES*8)-1) )
		begin
			oSLoad  		<= 1'b1; 
			rCounter_Out	<= 8'd0; 
		end
		else
		begin
			oSLoad 			<= 1'b0;
			rCounter_Out	<= rCounter_Out + 1'b1; 
		end 
	end 
end

always @ (negedge wSClock) 	
begin 
	if(!iReset) 
	begin
		ovDataIn 				<= {(TOTAL_OUTPUT_MODULES*8){1'b0}};
	end
	else			
	begin
		ovDataIn[rCounter_Out]  <= iSDataIn;
	end
end


//////////////////////////////////////////////////////////////////////
// Instances 
//////////////////////////////////////////////////////////////////////
// Generate 100KHz Clock
Toggle mToggle100KHz_SClock
(  
    .iRst(~iReset), 		//%Reset Input
	.iClk(iClk), 			//% Clock Input<br>
	.iCE(iCE),				//% Clock Enable
    .oTSignal(wSClock)		//% Output Signal Toggle
);

endmodule
