// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps

//////////////////////////////////////////////////////////////////////////////////
//  Event Logger
//////////////////////////////////////////////////////////////////////////////////
module EventLogger//% 32 inputs Event Logger
(
                    //% Clock Input
    input           iClk,
                    //% Asynchronous Reset Input
    input           iRst, 
                    //% Sample Enable Input Signal
    input           iSample,
                    //% Events Input
    input   [31:0]  ivInputs, 
    //Memory Interface
                    //% Event Memory Address
    output  [9:0]   ovAddress, 
                    //% Event Data Output
    output  [31:0]  ovData,
                    //% Memory Writes Enable Output
    output          oWE
    
);

//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

            
localparam  SAMPLE_STATE        =   3'd1;//%1: Sample State            
localparam  SET_EVENT_STATE     =   3'd2;//%2: Set Event State           
localparam  WRITE_EVENT_STATE0  =   3'd3;//%3: Write Event State0           
localparam  SET_TICKS_STATE     =   3'd4;//%4: Set Ticks State          
localparam  WRITE_TICKS_STATE0  =   3'd5;//%5: Write Ticks State0          
localparam  WRITE_TICKS_STATE1  =   4'd6;//%6: Write Ticks State1          
localparam  IDLE_STATE          =   3'd0;//%0: Idle State         

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
            //%Last Inputs Registers Data Input
reg [31:0]  rvLastInputs_d;
            //%Last Inputs Registers Output
reg [31:0]  rvLastInputs_q;
            //%State Register Data Input
reg [2:0]   rvState_d;
            //%State Register Output
reg [2:0]   rvState_q;
            //%Sample Enable Register Data Input
reg         rSample_d;
            //%Sample Enable Register Output
reg         rSample_q;
            //%Memory Address Register Data Input
reg [9:0]   rvAddress_d;
            //%Memory Address Register Output
reg [9:0]   rvAddress_q;
            //%Data Log Register Data Input
reg [31:0]  rvData_d;
            //%Data Log Register Output
reg [31:0]  rvData_q;
            //%Memory Write Enable Register Data Input
reg         rWE_d;
            //%Memory Write Enable Register Output
reg         rWE_q;
            //%Number of Ticks (Counter Output)
wire    [31:0]  wvTicks;


`ifdef USE_DEBUG
    (* KEEP = "TRUE" *) reg [6:0]   rvAction_d;
    (* KEEP = "TRUE" *) reg [6:0]   rvAction_q;
`endif
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign  oWE         =   rWE_q;
assign  ovAddress   =   rvAddress_q;
assign  ovData      =   rvData_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk or posedge iRst)
begin
    if(iRst)
    begin
        rvLastInputs_q      <=      32'b0;
        rvState_q           <=      IDLE_STATE;
        rSample_q           <=      1'b0;
        rvAddress_q         <=      10'b0;
        rvData_q            <=      32'b0;
        rWE_q               <=      1'b0;
    end 
    else    
    begin   
        rvState_q           <=      rvState_d;
        rvLastInputs_q      <=      rvLastInputs_d;
        rSample_q           <=      rSample_d;
        rvAddress_q         <=      rvAddress_d;
        rvData_q            <=      rvData_d;
        rWE_q               <=      rWE_d;
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
always @*
begin
    rSample_d       =   iSample;
    rvLastInputs_d  =   rvLastInputs_q;
    rvAddress_d     =   rvAddress_q;
    rvState_d       =   rvState_q;
    rWE_d           =   1'b0;
    rvData_d        =   rvData_q;
    case (rvState_q)
    SAMPLE_STATE:
    begin
        rvState_d       =   IDLE_STATE;
        rvLastInputs_d  =   ivInputs;
        if(( ivInputs != rvLastInputs_q )
            && ( rvAddress_q != 10'd1023 ))
        begin
            rvState_d   =   SET_EVENT_STATE;
            rvData_d    =   ivInputs;
        end
    end
    SET_EVENT_STATE:
    begin
        rWE_d           =   1'b1;
        rvState_d       =   WRITE_EVENT_STATE0;  
    end
    WRITE_EVENT_STATE0:
    begin
        rWE_d           =   1'b1;
        rvState_d       =   SET_TICKS_STATE;  
    end
    SET_TICKS_STATE:
    begin
        rvState_d       =   WRITE_TICKS_STATE0;
        rvAddress_d     =   rvAddress_q + 1'b1;
        rvData_d        =   wvTicks;
    end
    WRITE_TICKS_STATE0:
    begin
        rvState_d       =   WRITE_TICKS_STATE1;
        rWE_d           =   1'b1;
    end
    WRITE_TICKS_STATE1:
    begin
        rWE_d           =   1'b1;
        rvState_d       =   IDLE_STATE;
        rvAddress_d     =   rvAddress_q + 1'b1;
    end
    default:
    begin
        rvState_d       =   IDLE_STATE;
        if({rSample_q,iSample} == 2'b01)
        begin
            rvState_d   =   SAMPLE_STATE;
        end
    end
    endcase
end

//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////
/*
    \fn     mSampleCounter
    \brief  Event logger time base counter
*/
Counter #
(
    .TOTAL_BITS( 32 )
) mSampleCounter   //% Event logger time base
(
    .iClk       (iClk),
    .iRst       (iRst),
    .iCE        (iSample),
    .ovCnt      (wvTicks)
);

//////////////////////////////////////////////////////////////////////////////////
endmodule
