`timescale 1ns / 1ps

// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module EventsBRAMRegs
(   
    //! Module's clock input
    input           iClk,
    //! Reset input
    input           iRst,
    //! Enable input
    input           iEnable,
    //!
    output          oAccessDone,
    //! App Access
    input   [9:0]   ivAddress,
    input           iAppWE,
    input   [31:0]  ivAppData,
    input           iAppDataRst,    
    //! SMBus regs access
    input   [11:0]   ivRegID,
    output  [7:0]	 ovRegData
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
//!
wire        wDone;
//!
wire    [7:0]   wvRegOutData;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign  oAccessDone =   wDone;
assign  ovRegData   =   wvRegOutData;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////
Mem1Kx32_4Kx8 mEventBRAM
(
    .iClk           ( iClk ),
    .ivAddressA     ( ivAddress ),  //10 bits
    .ivAddressB     ( ivRegID ),    //11 bits
    .iWE            ( iAppWE ),
    .ivData         ( ivAppData ),  //32 bits
    .ovData         ( wvRegOutData ) //8 bits
);
//
//
//
uDelay #
(
    .TOTAL_BITS(4)
) mAccessDoneDelay
(
    .iClk           ( iClk ),
    .iRst           ( iRst ),
    .iCE            ( 1'b1),
    .iSignal        ( iEnable ),
    .oDelayedIn     ( wDone )
);
/////////////////////////////////////////////////////////////////////////////////


endmodule
