`timescale 1ns / 1ps

// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module Gen1Kx8BRAM
(
    //% Clock
    input           iClk,
    //% Port A Address
    input   [9:0]   ivAddressA,
    //% Port A input data
    input   [7:0]   ivDataA,
    //% Port A Write Enable
    input           iWEA,
    //% Port A output data
    output  [7:0]   ovDataA,
    //% Port B Address
    input   [9:0]   ivAddressB,
    //% Port B input data    
    input   [7:0]   ivDataB,
    //% Port B write enable
    input           iWEB,
    //% Port B output data
    output  [7:0]   ovDataB    
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////

reg [7:0]   rvvMem      [1023:0];
reg [7:0]   rvDataA;
reg [7:0]   rvDataB;

//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////

assign ovDataA =   rvDataA;
assign ovDataB =   rvDataB;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
//% Sequential logic
always @ (posedge iClk)
begin
    if ( iWEA )
    begin
        rvvMem[ivAddressA] <=  ivDataA;
    end
    rvDataA <=  rvvMem[ivAddressA];
end	 
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
//%Combinational logic
always @ (posedge iClk)
begin
    if ( iWEB )
    begin
        rvvMem[ivAddressB]  <=  ivDataB;
    end
    rvDataB <=  rvvMem[ivAddressB];
end	 
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
endmodule
