`timescale 1ps/1ps
// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module Mem1Kx32_4Kx8
(
    //% Clock
    input           iClk,
    //% PortA Address ( 1K )
    input   [9:0]   ivAddressA,
    //% PortB Address ( 4K )
    input   [11:0]  ivAddressB,
    //% Write enable
    input           iWE,
    //% PortA input data ( 32 bits)
    input   [31:0]  ivData,
    //% PortB output data ( 8 bits )
    output  [7:0]   ovData
);
wire    [7:0]   wvDO0;
wire    [7:0]   wvDO1;
wire    [7:0]   wvDO2;
wire    [7:0]   wvDO3;
reg     [7:0]   rvData;

assign  ovData  =   rvData;
//
//
//
always @(posedge iClk )
begin
    case ( ivAddressB[1:0] )
    2'd0:       rvData  <=  wvDO0;
    2'd1:       rvData  <=  wvDO1;
    2'd2:       rvData  <=  wvDO2;
    default:    rvData  <=  wvDO3;
    endcase
end
//
//
//
Gen1Kx8BRAM mBlok0
(
    .iClk           ( iClk ),
    .ivAddressA     ( ivAddressA ),
    .ivDataA        ( ivData[7:0] ),
    .iWEA           ( iWE ),
    .ovDataA        (),
    .ivAddressB     ( ivAddressB[11:2] ),
    .ivDataB        ( 8'b0 ),
    .iWEB           ( 1'b0 ),
    .ovDataB        ( wvDO0 )
);
//
//
//
Gen1Kx8BRAM mBlok1
(
    .iClk           ( iClk ),
    .ivAddressA     ( ivAddressA ),
    .ivDataA        ( ivData[15:8] ),
    .iWEA           ( iWE ),
    .ovDataA        (),
    .ivAddressB     ( ivAddressB[11:2] ),
    .ivDataB        ( 8'b0 ),
    .iWEB           ( 1'b0 ),
    .ovDataB        ( wvDO1 )
);
//
//
//
Gen1Kx8BRAM mBlok2
(
    .iClk           ( iClk ),
    .ivAddressA     ( ivAddressA ),
    .ivDataA        ( ivData[23:16] ),
    .iWEA           ( iWE ),
    .ovDataA        (),
    .ivAddressB     ( ivAddressB[11:2] ),
    .ivDataB        ( 8'b0 ),
    .iWEB           ( 1'b0 ),
    .ovDataB        ( wvDO2 )
);
//
//
//
Gen1Kx8BRAM mBlok3
(
    .iClk           ( iClk ),
    .ivAddressA     ( ivAddressA ),
    .ivDataA        ( ivData[31:24] ),
    .iWEA           ( iWE ),
    .ovDataA        (),
    .ivAddressB     ( ivAddressB[11:2] ),
    .ivDataB        ( 8'b0 ),
    .iWEB           ( 1'b0 ),
    .ovDataB        ( wvDO3 )
);
//
//
//


endmodule
	