// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module MainVR_Seq
(
	input			 iClk,//%Clock input.
	input			 iRst_n,//%Reset enable on high.

	input            iGoOutFltSt,//% Go out fault state.
	input            iMainVRPwrEn,//% Turn on Main VR's.
	input            PWRGD_PS_PWROK,//% PWRGD PS PWROK .

    input            PWRGD_P3V3,//% Pwrgd from P3V3 VR 

    output  reg      oMainPwrFlt,//% Fault condition.
    output  reg      oP3v3PwrFlt, //% Fault P3V3 VR
    output  reg      oMainVRPwrgd,//% Main Vr's Enable
   
	output reg       FM_AUX_SW_EN,//% 12V Only PSU Control  AUX to Main SW
	output reg       FM_P5V_EN//% P5V and P3V3 main Voltage enable

);


//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////

	parameter  LOW =1'b0;
	parameter  HIGH=1'b1;


//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////

reg  rPwrgd_P5V_P3V3_ff1;



//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////

always @ ( posedge iClk) 
	begin 
		if (  !iRst_n  )   
			begin

				oMainVRPwrgd        	<= LOW;
				oP3v3PwrFlt  			<= LOW;  					
				rPwrgd_P5V_P3V3_ff1 	<= LOW;
				FM_AUX_SW_EN        	<= LOW;
				FM_P5V_EN           	<= LOW;
				oMainPwrFlt         	<= LOW;
									
			end 
		else if ( iGoOutFltSt )
			begin				
				oMainPwrFlt 	   		<= LOW;
				oP3v3PwrFlt        		<= LOW;
			end
		else 
			begin	
								
				FM_AUX_SW_EN         	<= PWRGD_PS_PWROK;	 					
				FM_P5V_EN 	         	<= iMainVRPwrEn;    // P5V power good enables P3V3	
		
				oMainVRPwrgd         	<= PWRGD_P3V3;

				rPwrgd_P5V_P3V3_ff1  	<= PWRGD_P3V3;

				oP3v3PwrFlt       		<= (FM_P5V_EN      && (!PWRGD_P3V3)      && rPwrgd_P5V_P3V3_ff1 ) ? HIGH: oP3v3PwrFlt; 
				oMainPwrFlt       		<= (PWRGD_PS_PWROK && (oP3v3PwrFlt ))                             ? HIGH: oMainPwrFlt; 	


			end
	end  



//////////////////////////////////////////////////////////////////////
// Instances 
///////////////////////////////////////////////////////////////////////


endmodule 