// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module PSU_Seq
(
	input			 iClk,//%Clock input.
	input			 iRst_n,//%Reset enable on high.
	input 			 i1mSCE, //% 1 mS Clock Enable.
	input            iGoOutFltSt,//% Go out fault state.
	input            iPsuPwrEn,//% Psu enable.
    input            PWRGD_PS_PWROK,//% PWRGD with generate by Power Supply .
 

	output  reg   	oPsuPwrFlt,//% Fault condition.
	output  reg   	oPsuPwrgd,//% Internal PWRGD with delay and giltch filter.
	output        	PWRGD_PS_PWROK_DLY, //%  PWRGD with delay.
	output        	FM_PS_EN	  //% PS_ON used to turn ON/OFF the Power Supply.
);


//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////
parameter  LOW =1'b0;
parameter  HIGH=1'b1;


//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////

reg  rPsPwrokDly_ff1, rPsPwrokDly_ff2;


//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////

always @ ( posedge iClk) 
begin 
	if (  !iRst_n  )   
	begin
		oPsuPwrgd          		<= LOW;
		oPsuPwrFlt  			<= LOW;  					
		rPsPwrokDly_ff1 		<= LOW;
		rPsPwrokDly_ff2 		<= LOW;
	end 
	else if ( iGoOutFltSt )
	begin				
		oPsuPwrFlt 				<= LOW;
	end
	else 
	begin
		// oPsuPwrgd               <= PWRGD_PS_PWROK_DLY;
		oPsuPwrgd             	<= PWRGD_PS_PWROK;
							
		oPsuPwrFlt  			<= (FM_PS_EN && (!PWRGD_PS_PWROK_DLY) && rPsPwrokDly_ff1 && rPsPwrokDly_ff2) ? HIGH: oPsuPwrFlt;//% Fault 					
		
		rPsPwrokDly_ff1 		<= PWRGD_PS_PWROK_DLY; 	//% used to edge detector 
		rPsPwrokDly_ff2 		<= rPsPwrokDly_ff1;		//% used to edge detector 
	end
end  


//////////////////////////////////////////////////////////////////////
// Instances 
///////////////////////////////////////////////////////////////////////
SignalValidationDelay#
(
    .VALUE                  ( 1'b1 ),
    .TOTAL_BITS             ( 3'd7 ),
    .POL                    ( 1'b1 )
)mPS_PWROK_DLY         
(           
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .iCE                    ( i1mSCE ),
    .ivMaxCnt               ( 7'd100 ),        //100ms delay
    .iStart                 ( PWRGD_PS_PWROK),
    .oDone                  ( PWRGD_PS_PWROK_DLY )
);

SignalValidationDelay#
(
    .VALUE                  ( 1'b1 ),
    .TOTAL_BITS             ( 2'd3 ),
    .POL                    ( 1'b1 )
)mPS_EN_dly        
(           
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .iCE                    ( i1mSCE ),
    .ivMaxCnt               ( 3'd5 ),    //5ms delay
    .iStart                 ( iPsuPwrEn),
    .oDone                  ( FM_PS_EN )
);
endmodule 