// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module Prochot
(
	input      iClk, //%Clock input 2 Mhz   
    input      iRst_n,//%Reset enable on low  
    input      PWRGD_SYS_PWROK,	
    input      FM_PVCCIN_PWR_IN_ALERT_N,
    input      IRQ_PVCCIN_VRHOT_LVC3_N,
    input      FM_SYS_THROTTLE_LVC3, 
    input      FM_SKTOCC_LVT3_N,

    output reg FM_PROCHOT_LVC3_N
);


//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////

	parameter  LOW =1'b0;
	parameter  HIGH=1'b1;

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////

always @( posedge iClk) 
	begin 
		if  (!iRst_n || FM_SKTOCC_LVT3_N)  
			begin
				FM_PROCHOT_LVC3_N         <= HIGH;
			end		
		else begin
				FM_PROCHOT_LVC3_N         <= PWRGD_SYS_PWROK ? ( (!FM_SYS_THROTTLE_LVC3 && FM_PVCCIN_PWR_IN_ALERT_N && IRQ_PVCCIN_VRHOT_LVC3_N )) : HIGH;
			end 
	end 


endmodule

