// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module PwrgdLogic
(
	input			iClk,//%Clock input
	input			iRst_n,//%Reset enable on high
	input 		    i1mSCE, //% 1 mS Clock Enable
	
	input           iMemPwrgd,//% Memory Pwrgd generate Mem_Seq.v
	input           iCpuPwrgd,//% Cpu Pwrgd generate Cpu_Seq.v
	input           iBmcPwrgd,//% Bmc Pwrgd generate Bmc_Seq.v
	input           iPchPwrgd,//% Pch Pwrgd generate Pch_Seq.v	
	input           FM_SLPS3_N,//% SLP3# from PCH
	input           FM_SLPS4_N,//% SLP4# from PCH
	input           PWRGD_PS_PWROK_DLY,//% PWRGD with generate by Power Supply with Delay.
	input           DBP_SYSPWROK,  //%DBP_SYSPWROK signal from DBP Connector
	input           PWRGD_CPUPWRGD, //& CPUPWRGD from PCH

	output reg      PWRGD_DRAMPWRGD_CPU, 
	output 			PWRGD_CPU_LVC3,
    output          PWRGD_PCH_PWROK, //% Pwrgd PCH 
    output reg      PWRGD_SYS_PWROK //% Pwrgd SYS 
);

//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////
parameter  LOW =1'b0;
parameter  HIGH=1'b1;

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
reg rPWRGD_PCH_PWROK, rPWRGD_PCH_PWROK_ff;


//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////
assign PWRGD_CPU_LVC3 = PWRGD_CPUPWRGD;	//This to help Modular design timing requirements for CPUs PWRGD


//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////
reg rPWRGD_PS_PWROK_q;
reg rPCHPwrokNegEdge;

always @ ( posedge iClk) 
begin 
	if (  !iRst_n  )   
	begin
		rPWRGD_PCH_PWROK   	<= LOW;
		rPWRGD_PCH_PWROK_ff	<= LOW;
		PWRGD_SYS_PWROK    	<= LOW;
		PWRGD_DRAMPWRGD_CPU	<= LOW;
		rPWRGD_PS_PWROK_q	<= LOW;
		rPCHPwrokNegEdge 	<= LOW;
	end
	else 
	begin	
		rPWRGD_PCH_PWROK   <=  ( rPCHPwrokNegEdge ) ? PWRGD_PS_PWROK_DLY : (iMemPwrgd && iCpuPwrgd && iBmcPwrgd && iPchPwrgd && FM_SLPS3_N && PWRGD_PS_PWROK_DLY);
		rPWRGD_PCH_PWROK_ff<=	rPWRGD_PCH_PWROK;
		PWRGD_SYS_PWROK    <=  PWRGD_PCH_PWROK && DBP_SYSPWROK;	
		PWRGD_DRAMPWRGD_CPU<=  FM_SLPS4_N && iMemPwrgd;
		rPWRGD_PS_PWROK_q	<= PWRGD_PS_PWROK_DLY;
		rPCHPwrokNegEdge    <= (!PWRGD_PS_PWROK_DLY && rPWRGD_PS_PWROK_q && FM_SLPS3_N) ?  1'b1 : rPCHPwrokNegEdge;
	end
end  


//////////////////////////////////////////////////////////////////////
// Instances 
//////////////////////////////////////////////////////////////////////
SignalValidationDelay#
(
    .VALUE                  ( 1'b1 ),
    .TOTAL_BITS             ( 2'd3 ),
    .POL                    ( 1'b1 )
)mPWRGD_PCH_Pwrok_DLY         
(           
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .iCE                    ( i1mSCE ),
    .ivMaxCnt               ( 3'd6 ),        //6ms delay
    .iStart                 ( rPWRGD_PCH_PWROK || rPWRGD_PCH_PWROK_ff),
    .oDone                  ( PWRGD_PCH_PWROK )
);

endmodule
