// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module SmaRT
(
	input      iClk, //%Clock input 2 Mhz   
    input      iRst_n,//%Reset enable on low
    input      IRQ_SML1_PMBUS_PLD_ALERT_N,   
    input      FM_PMBUS_ALERT_B_EN,
    input      FM_THROTTLE_N,  
    input      PWRGD_SYS_PWROK,	

    output reg FM_SYS_THROTTLE_LVC3//% The logic is inverted using a FET.
);


//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////
parameter  LOW =1'b0;
parameter  HIGH=1'b1;

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
//Generate IRQ_SML1_PMBUS_ALERT_BUF_N to replace the On-Board Logic
reg  rIrqSml1_PMbus_Alert_Buf_N;


//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////

always @( posedge iClk) 
begin 
	if  (!iRst_n)  
	begin				
		rIrqSml1_PMbus_Alert_Buf_N <= HIGH;
		FM_SYS_THROTTLE_LVC3       <= LOW;
	end
	else 
	begin
		rIrqSml1_PMbus_Alert_Buf_N <= FM_PMBUS_ALERT_B_EN ? IRQ_SML1_PMBUS_PLD_ALERT_N : HIGH;
		FM_SYS_THROTTLE_LVC3       <= PWRGD_SYS_PWROK ? (~ (rIrqSml1_PMbus_Alert_Buf_N && FM_THROTTLE_N)) : LOW;
	end 
end 

endmodule
