// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//         ClkDiv
//////////////////////////////////////////////////////////////////////////////////

module ClkDiv # //%Parameterizable Synchronus Clock Divider
(
                //% Counter bits
    parameter   MAX_DIV_BITS = 4, 
                //% Maximun count value
    parameter   MAX_DIV_CNT = 15  
)
(
            //% Clock Input    
    input   iClk,
            //% Asynchronous Reset Input
    input   iRst,
            //% Clock Enable from a previous stage
    input   iCE,
            //% Output Divided Clock Signal
    output  oDivClk
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
                                //% Internal Counter register input equation
reg    [(MAX_DIV_BITS - 1):0]   rvDivCnt_d;
                                //% Internal Counter register Output
reg    [(MAX_DIV_BITS - 1):0]   rvDivCnt_q;
                                //% Divided Clock register input equation
reg                             rDivClk_d;
                                //% Divided Clock register output
reg                             rDivClk_q;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigment
//////////////////////////////////////////////////////////////////////////////////
assign    oDivClk    =    rDivClk_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential Section
//////////////////////////////////////////////////////////////////////////////////
//% Sequential Section
always @(posedge iClk or posedge iRst)
begin
    if(iRst)                                    //Reset?
    begin
        rvDivCnt_q  <=  {MAX_DIV_BITS{1'b0}};   // Yes, then set Count Reset to all 
        rDivClk_q   <=  1'b0;                   //0's and Divided Clock 0
    end
    else
    begin
        if(iCE)                                 //No, Clock Enable?
        begin
            rvDivCnt_q  <=  rvDivCnt_d;         // Yes, then update Count register
        end
        else
        begin
            rvDivCnt_q  <=  rvDivCnt_q;         // No, then keep the same value
        end
        rDivClk_q   <=  rDivClk_d;              //Update Divided Clock Signal 
                                                //Register
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational Section
//////////////////////////////////////////////////////////////////////////////////
//% Combinational Section
always @*
begin
    //Clock divider will be set to 1 when rvDivCnt_q reaches the MAX_DIV_CNT
    rDivClk_d   =   (iCE) ? (rvDivCnt_q == MAX_DIV_CNT) : 1'b0; 
    //rvDivCnt will be incremented while it is below the MAX_DIV_CNT, otherwise
    //it is set to 0
    rvDivCnt_d  =   {MAX_DIV_BITS{1'b0}};   
    if(rvDivCnt_q != MAX_DIV_CNT)   
    begin
        rvDivCnt_d  =   rvDivCnt_q + 1'b1;
    end
end
//////////////////////////////////////////////////////////////////////////////////
//Instances
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
endmodule
