// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//         module EdgeDetector     
//////////////////////////////////////////////////////////////////////////////////
module EdgeDetector # //%Parameterizable Edge Detector<br>
(
                //% Defines Positive Edge (1) or Negative Edge (0)<br>
    parameter   EDGE = 1
)
(
            //% Clock Input<br>
    input   iClk,
            //% Asynchronous Reset Input<br>
    input   iRst,
            //% Monitored Input Signal<br>
    input   iSignal,
            //% Edge Detected Flag<br>
    output  oEdgeDetected
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
                //% Signal Before/After registers Input equation<br>
reg    			rSignal_d;
                //% Signal Befor/After registers Output<br>
reg    			rSignal_q;
                //% Edge Register Input equation<br>
reg             rEdge_d;
                //% Edge Register Output<br>
reg             rEdge_q;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign oEdgeDetected = rEdge_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
//% Sequential Section<br>
always @(posedge iClk or posedge iRst)
begin
    if(iRst)                                    //Reset?
    begin
        rSignal_q	<=    1'b0;       		//Yes, then before/after registers  
        rEdge_q     <=    1'b0;               //are set with the iSignal and        
    end                                         //the Edge register is cleared with
    else                                        //0.
    begin
        rSignal_q   <=    rSignal_d;         //No, then all registers are updated.
        rEdge_q     <=    rEdge_d;
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
//% Combinational Section<br>
always @*
begin
    // The Before/After register is loaded with present iSignal and the last iSignal
    //value.
    rSignal_d    	=    iSignal;
    if(EDGE)                                               //posEdge or negEdge?
    begin
        rEdge_d     =   ~rSignal_q & iSignal;    //posEdge, then the flag
    end                                                    //is set when the positive
    else                                                   //transition is registered.
    begin
        rEdge_d     =   rSignal_q & ~iSignal;    //negEdge, then the flag 
    end                                                    //is set when the negative
end                                                        //transition is registered.
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

endmodule
