// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//      FF SR
//////////////////////////////////////////////////////////////////////////////////
module FF_SR //% Flip Flop SR
(
                    //% Clock Input<br>
    input           iClk,
                    //% Asynchronous Reset Input<br>
    input           iRst,
                    //% Register Set<br>
    input           iSet,
                    //% Register Output<br>
    output          oQ
);

//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
//%
reg    rQ_d;
reg    rQ_q;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign  oQ    =   rQ_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk)
begin
    if(iRst)                            //Reset?
    begin
        rQ_q    <=    1'b0;             //Yes, then reset the register output to 0.
    end
    else
    begin
        if(iSet)
        begin
            rQ_q    <=    1'b1;         //No, then if iSet is up, set the register
        end                             //output to 1.
        else
        begin
            rQ_q    <=    rQ_d;        //else, the register output doesn't change.
        end
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
always @*
begin
    rQ_d    =   rQ_q;
end
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
endmodule