`timescale 1ns / 1ps

// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module GSX #(parameter TOTAL_INPUT_MODULES = 8, TOTAL_OUTPUT_MODULES = 8)
(
    //% Serial Data input
    input                                   iGSXDataIn,
    //% Serial Clock
    input                                   iGSXClk,
    //% Load control
    input                                   inGSXLoad,
    //% Reset
    input                                   inGSXReset,
    //% Data to transmit vector
    input   [(TOTAL_OUTPUT_MODULES*8)-1:0]  ivTxData,    
    //% Serial Data output
    output                                  oGSXDataOut,
    //% Received data vector    
    output  [(TOTAL_INPUT_MODULES*8)-1:0]   ovRxData
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
//!
reg [(TOTAL_OUTPUT_MODULES*8)-1:0]  rvTxShifter_d;
reg [(TOTAL_OUTPUT_MODULES*8)-1:0]  rvTxShifter_q;
//!
reg [(TOTAL_INPUT_MODULES*8)-1:0]   rvRxShifter_d;
reg [(TOTAL_INPUT_MODULES*8)-1:0]   rvRxShifter_q;
//!
reg [(TOTAL_INPUT_MODULES*8)-1:0]   rvOutput_d;
reg [(TOTAL_INPUT_MODULES*8)-1:0]   rvOutput_q;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign  ovRxData    =   rvOutput_q;
assign  oGSXDataOut =   rvTxShifter_q[(TOTAL_OUTPUT_MODULES*8)-1];
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
always @ (posedge iGSXClk)
begin
	if ( !inGSXLoad )
	begin
		rvTxShifter_q   <=  ivTxData;
	end
	else
	begin
		rvTxShifter_q   <=  rvTxShifter_d;		
	end
end
//////////////////////////////////////////////////////////////////////////////////
always @ (posedge iGSXClk)
begin
	if ( !inGSXReset ) 
	begin
		rvRxShifter_q   <=  {(TOTAL_INPUT_MODULES*8){1'b0}};	
	end
	else
	begin
        rvRxShifter_q   <=  rvRxShifter_d;	
	end
end

reg prev_inGSXLoad;
always @ (posedge iGSXClk)
begin
	if (inGSXLoad && !prev_inGSXLoad)
	begin
		rvOutput_q  <=  rvOutput_d;
	end
	prev_inGSXLoad <= inGSXLoad;
end


//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
always @*
begin
    rvOutput_d      =   rvRxShifter_q;   
    rvRxShifter_d   =   { rvRxShifter_q[(TOTAL_INPUT_MODULES*8)-2:0], iGSXDataIn};
    rvTxShifter_d   =   { rvTxShifter_q[((TOTAL_OUTPUT_MODULES*8)-2):0], 1'b0 };    
end
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
endmodule
