// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//  Glitch Filter
//////////////////////////////////////////////////////////////////////////////////
module GlitchFilter # //% <br>
(
    parameter   TOTAL_STAGES = 3
)
(
                //% Clock Input<br> 
    input       iClk,
                //% Asynchronous Reset Input<br>
    input       iRst,
                //% Clock Enable from a previous stage<br>
    input       iCE,
                //% Input Signals<br>
    input       iSignal,
                //%Glitchless Signal Flag<br>
    output      oGlitchlessSignal
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
                        //%Glitchless Signal Register Data Input<br>
reg                     rGlitchlessSignal_d;
                        //%Glitchless Signal Register Output<br>
reg                     rGlitchlessSignal_q;

                        //%Sampled Data Register Data Input<br>
reg [TOTAL_STAGES-1:0]  rvSampledData_d;
                        //%Sampled Data Register Output<br>
reg [TOTAL_STAGES-1:0]  rvSampledData_q;


//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign  oGlitchlessSignal   =   rGlitchlessSignal_q;

//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk or posedge iRst)
//If Reset, then the GlitchlessSignal is set to 0 and all the Sampled Data  
//Registers outputs are set with the present input Signal value.

//If no, then the Glitchless Signal register data is updated and if the Clock 
//enable is high, also the Sampled Data registers.
//Otherwise, the Sampled Data registers maintains their values.
begin
    if(iRst)                                                    
    begin
        rGlitchlessSignal_q     <=      1'b0;                           
        rvSampledData_q         <=      {TOTAL_STAGES{1'b0}};    
    end
    else
    begin
        rGlitchlessSignal_q     <=      rGlitchlessSignal_d;
        if(iCE)
        begin
            rvSampledData_q     <=      rvSampledData_d;
        end
        else
        begin
            rvSampledData_q     <=      rvSampledData_q;
        end
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
//Compares the sampled data among themselves and if the data values are consistent 
//in all stages, stablish a Glitchless Signal with it.
always @*
begin
    rvSampledData_d         =    {rvSampledData_q[(TOTAL_STAGES-2):0],iSignal};
    rGlitchlessSignal_d     =    rGlitchlessSignal_q;
    if(~|rvSampledData_q)
    begin
        rGlitchlessSignal_d =   1'b0;
    end
    if(&rvSampledData_q)
    begin
        rGlitchlessSignal_d =   1'b1;
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

endmodule
//////////////////////////////////////////////////////////////////////////////////