// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module Mux128BitsTo8 //The selector can select by groups of 8 
(
	input  [3:0]    		  iSel, //%Selector this will select what group you need measure.
	input  [127:0]            ivSignals,
	output reg [7:0]          ovSignals	 
);



//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
//%Combinational logic<br>
always @*
begin
    // Combinational assigments
    case ( iSel ) 
                4'h0:       ovSignals    =   ivSignals[7:0];
                4'h1:       ovSignals    =   ivSignals[15:8];
                4'h2:       ovSignals    =   ivSignals[23:16];
                4'h3:       ovSignals    =   ivSignals[31:24];
                4'h4:       ovSignals    =   ivSignals[39:32];
                4'h5:       ovSignals    =   ivSignals[47:40];
                4'h6:       ovSignals    =   ivSignals[55:48];
                4'h7:       ovSignals    =   ivSignals[63:56];
                4'h8:       ovSignals    =   ivSignals[71:64];
                4'h9:       ovSignals    =   ivSignals[79:72];
                4'hA:       ovSignals    =   ivSignals[87:80];
                4'hB:       ovSignals    =   ivSignals[95:88];
                4'hC:       ovSignals    =   ivSignals[103:96];
                4'hD:       ovSignals    =   ivSignals[111:104];
                4'hE:       ovSignals    =   ivSignals[119:112];
                4'hF:       ovSignals    =   ivSignals[127:120];
                default:    ovSignals    =   ivSignals[7:0];             
            endcase
end
endmodule