// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module  Rst_Perst # 
(
    parameter   NUM_PCIE_SIGNALS = 7 //% Number of PCIE resets <br>
)
(
    input           iClk, //% System Clock - 2MHz    
    input           iRst_n,//% System asynchronous reset  
    	//% PERST Table control
    input   [NUM_PCIE_SIGNALS-1:0] ivOverride_Enable,//% Override Enable 
	input   [NUM_PCIE_SIGNALS-1:0] ivOvrValues,//% Override values
	input   [NUM_PCIE_SIGNALS-1:0] ivDefaultValues, //% Default values
	
    output  [NUM_PCIE_SIGNALS-1:0] ovRstPCIePERst_n //% Output PCIE Resets for PERST Table
);

//////////////////////////////////////////////////////////////////////
// Instances 
//////////////////////////////////////////////////////////////////////
//% CPU PCIe Reset output generation - PltRst or CPUPwrGd selection
SignalOverrideControl #
(
    .TOTAL_SIGNALS ( NUM_PCIE_SIGNALS )
)mPERst
(
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .ivOvrEnable            ( ivOverride_Enable ),
    .ivOvrValue             ( ivOvrValues ),
    .ivSignal               ( ivDefaultValues ),
    .ovSignal               ( ovRstPCIePERst_n )
);

endmodule

