// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//          SignalOverrideControl
//////////////////////////////////////////////////////////////////////////////////

module SignalOverrideControl #(parameter TOTAL_SIGNALS = 16)
(
                                    //% Clock Input
	input                           iClk,
                                    //% Asynchronous Reset Input
	input                           iRst,
                                    //% Override Enable Input vector
    input   [(TOTAL_SIGNALS-1):0]   ivOvrEnable,
                                    //% Override Value Input vector
    input   [(TOTAL_SIGNALS-1):0]   ivOvrValue,
                                    //% Input vector
    input   [(TOTAL_SIGNALS-1):0]   ivSignal,
                                    //% Siganl override or signal output vector
    output  [(TOTAL_SIGNALS-1):0]   ovSignal
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
                            //%Mux output, override value or input signal
reg [(TOTAL_SIGNALS-1):0]   rvSignal_d;
reg [(TOTAL_SIGNALS-1):0]   rvSignal_q;
//!
integer iIndex;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign ovSignal = rvSignal_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk)
begin
    if(iRst)
    begin
        rvSignal_q  <=  ivSignal;
    end
    else
    begin
        rvSignal_q  <=  rvSignal_d;
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
always @*
begin
    for(iIndex = 0; iIndex < TOTAL_SIGNALS; iIndex = iIndex + 1)
    begin
        rvSignal_d[iIndex]  =   ivOvrEnable[iIndex] ? ivOvrValue[iIndex] : ivSignal[iIndex];    
    end                                      //Mux for each input signal to be able                                                    
end                                          //to select override value or input signal
//////////////////////////////////////////////////////////////////////////////////
//  History
//////////////////////////////////////////////////////////////////////////////////
/*
    $Log: SignalOverrideControl.v.rca $
    
     Revision: 1.4 Thu Sep  5 17:21:45 2013 dggarci2
     updated code comments
    
     Revision: 1.3 Thu Sep  5 10:20:44 2013 dggarci2
     Added Doxygen tags and comments
    
*/
//////////////////////////////////////////////////////////////////////////////////
endmodule
