// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//      SignalValidationDelay
//////////////////////////////////////////////////////////////////////////////////
module SignalValidationDelay#
(
    
    parameter   VALUE         = 1'b1, 
                //% Counter Total Bits
    parameter   TOTAL_BITS    = 3'd4, 
                //% Counter Maximun value
    parameter   MAX_COUNT     = 4'd10, 
                //% Signal Polarity
    parameter   POL           = 1'b1
)
(
                                    //% Clock Input
    input                           iClk,
                                    //% Asynchronous Reset Input
    input                           iRst,
                                    //% Clock Enable
    input                           iCE,
                                    //% Counter Maximun Value
    input   [(TOTAL_BITS - 1):0]    ivMaxCnt,
                                    //% Start
    input                           iStart,
                                    //% Done
    output                          oDone
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////

reg                     rDone_d;
reg                     rDone_q;

reg [(TOTAL_BITS-1):0]  rvCounter_d;
reg [(TOTAL_BITS-1):0]  rvCounter_q;

wire    wRst = iRst || (iStart ^ VALUE);
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign    oDone = rDone_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk or posedge wRst) 
begin
    if (wRst)
    begin
        rDone_q 	<= ~POL;
        rvCounter_q <= {TOTAL_BITS{1'b0}};
    end
    else
    begin
        rDone_q				<= rDone_d;
        if(iCE)
        begin
            rvCounter_q		<= rvCounter_d;
        end
        else
        begin
            rvCounter_q		<= rvCounter_q;
        end
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
always @* 
begin
    rDone_d = ~POL;
    rvCounter_d =   rvCounter_q;
    if(rvCounter_q < ivMaxCnt)
    begin
        rvCounter_d     =   rvCounter_q + 1'b1;
    end
    else
    begin
        rDone_d =   POL;    
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////
endmodule
