// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module SingleLatcher#
(

	parameter        EDGELATCH = 1

)
(
	input		        iClk,//%Clock input 
	input		        iRst_n,//%Reset enable on low
	input 				iEnableLatch,
	input               iSignalLatch,

	output              oSignalLatched

);



//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////

wire wLatchClr;
wire wLatchSet;
wire wSignalLatched;

//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////

//since the latch is really control by clear condition depending of EDGELATCH
//by this reason is needed invert for the case when the condition of EDGELATCH=1

assign oSignalLatched = EDGELATCH ? ~wSignalLatched : wSignalLatched;

//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

EdgeDetector #
(
    .EDGE                   ( 1 )
)mLatchSet
(
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .iSignal                ( iEnableLatch ),              
    .oEdgeDetected          ( wLatchSet )
);

EdgeDetector #
(
    .EDGE                   ( EDGELATCH )
)mLatchClr
(
    .iClk                   ( iClk ),
    .iRst                   ( ~iRst_n ),
    .iSignal                (iSignalLatch), 
    .oEdgeDetected          ( wLatchClr )
);


FF_SR mLatchOut
(
    .iClk                   ( iClk ),
    .iRst                   ( wLatchClr),
    .iSet                   ( wLatchSet || ~iRst_n),
    .oQ                     ( wSignalLatched )
);

endmodule