`timescale 1ns / 1ps
// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module SyncWithDefault #(parameter DEFAULT_OUT = 1'b0)
(
    input        iClk,
    input        iRst_n,
    input        iSignal,
    output    oSyncSignal
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
//Internal Signals
//////////////////////////////////////////////////////////////////////////////////
//!
//reg    [1:0]    rvSyncSignal_d;
reg     rSyncSignal_ff1;
reg 	rSyncSignal_ff2;
//////////////////////////////////////////////////////////////////////////////////
//Continous assigment
//////////////////////////////////////////////////////////////////////////////////
assign    oSyncSignal    = rSyncSignal_ff2;
//////////////////////////////////////////////////////////////////////////////////
//Sequential Section
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk or negedge iRst_n)
begin
    if( !iRst_n)
    begin
        rSyncSignal_ff1    <= DEFAULT_OUT;
        rSyncSignal_ff2    <= DEFAULT_OUT;
    end
    else
    begin
        rSyncSignal_ff1   <= iSignal;
        rSyncSignal_ff2 <= rSyncSignal_ff1;
    end
end
//////////////////////////////////////////////////////////////////////////////////
//Combinational Section
//////////////////////////////////////////////////////////////////////////////////
//always @*
//begin
  //  rvSyncSignal_d    = {rvSyncSignal_q[0],iSignal};
//end
//////////////////////////////////////////////////////////////////////////////////
//Instances
//////////////////////////////////////////////////////////////////////////////////

endmodule
//////////////////////////////////////////////////////////////////////////////////