// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
//           module ModCounter  
//////////////////////////////////////////////////////////////////////////////////
module Counter # //%Parameterizable Counter
(
                //% Counter bits
    parameter   TOTAL_BITS = 4
)
(
                                //% Clock Input
    input                       iClk,
                                //% Asynchronous Reset Input
    input                       iRst,
                                //% Clock Enable from a previous stage
    input                       iCE,
                                //% Output Count value
    output [(TOTAL_BITS-1):0]   ovCnt
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
                        //% Internal counter register input equation
reg [(TOTAL_BITS-1):0]  rvCnt_d;
                        //% Internal counter register Output
reg [(TOTAL_BITS-1):0]  rvCnt_q;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign  ovCnt = rvCnt_q;
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
//% Sequential Logic
always @(posedge iClk or posedge iRst)
begin
    if(iRst)                                    //Reset?
    begin
        rvCnt_q <= {TOTAL_BITS{1'b0}};          //Yes, then Count register is 
    end                                         //cleared to 0's.
    else
    begin
        if(iCE)                                 //Clock Enable?
        begin
            rvCnt_q <= rvCnt_d;                 //Yes, then the count register is
        end                                     //updated.
        else
        begin
            rvCnt_q <=  rvCnt_q;                //No, then the count register 
        end                                     //doesn't change
    end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
//% Combinational Logic
always @*
begin
    rvCnt_d = rvCnt_q + 1'b1;                   //The count increases by 1.
end
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////
endmodule

