// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module eSPI_Ctl
(
	input			 iClk,//%Clock input
	input			 iRst_n,//%Reset enable on high
	input            i1uSCE,//% 1 uS Clock Enable 
	input            RST_SRST_BMC_N,//% SRST RST# from BMC
	input            iRsmRst_N,//% RSM RST# from PCH

    output  reg      oEspiMuxPCHSel,//% Mux selector control for PCH
    output  reg      oEspiMuxBMCSel//% Mux selector control for BMC
);


//////////////////////////////////////////////////////////////////////////////////
// Parameters
//////////////////////////////////////////////////////////////////////////////////

	parameter  LOW =1'b0;
	parameter  HIGH=1'b1;


//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////



wire            wPCHESPIMuxSel;
wire            wBMCStrapSample;

//////////////////////////////////////////////////////////////////////////////////
// Continuous assignments
//////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////
// Secuencial Logic
//////////////////////////////////////////////////////////////////////////////////

always @ ( posedge iClk) 
	begin 
		if (  !iRst_n  )   
			begin				
				oEspiMuxPCHSel      <= LOW;
				oEspiMuxBMCSel      <= LOW;
			end					
		
		else 
			begin				
				oEspiMuxPCHSel	 <=  wPCHESPIMuxSel;
				oEspiMuxBMCSel	 <=  wBMCStrapSample;
			end
	end  



//////////////////////////////////////////////////////////////////////
// Instances 
///////////////////////////////////////////////////////////////////////

//% RSMRst Sample delay (2uS) 

uDelay #
(
	.TOTAL_BITS ( 2'd2 )
)mDelayedRsmRst
(
	.iClk					( iClk ),
	.iRst					( !iRst_n ),
	.iCE					( i1uSCE ),
	.iSignal				( iRsmRst_N ),
	.oDelayedIn				( wPCHESPIMuxSel )
);



//% BMCRst Sample delay (2uS) 
//
uDelay #
(
	.TOTAL_BITS ( 2'd2 )
)mDelayedBMCRst
(
	.iClk					( iClk ),
	.iRst					( !iRst_n ),
	.iCE					( i1uSCE ),
	.iSignal				( RST_SRST_BMC_N ),
	.oDelayedIn				( wBMCStrapSample )
);
endmodule 
