// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module genCntr
#(
   //================= Parameters ==============
     parameter MAX_COUNT = 1000                       //number of clock cycles to count
)
(  //================= Outputs ================= 
     output wire  oCntDone,                    //It is high when max count has been reached 

   //================= Inputs =================
     input  wire  iClk,                          //Clock signal
     input  wire  iCntEn,	                   //Counter enable 
     input  wire  iRst_n,                        //reset
     input  wire  iCntRst_n,                   //synchronous reset
	  
     output reg   [logb2(MAX_COUNT) : 0]  oCntr	
);

   //+----+----+----+----+----+----+----+----+----+
   //Local functions
   //+----+----+----+----+----+----+----+----+----+	
   
	 function integer logb2 ( input integer size );
	    integer size_buf;
     begin
          size_buf = size;
			for(logb2=-1; size_buf>0; logb2=logb2+1) size_buf = size_buf >> 1;
     end
     endfunction

	  	  
   //-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//	 
     always @ ( posedge iClk or negedge iRst_n ) 
     begin
 
           if ( !iRst_n )               oCntr  <= 0; 
           else if( !iCntRst_n )       oCntr   <= 0; 
           else 
           begin
						
                if ( oCntr == MAX_COUNT )   
                begin 
				    oCntr   <= oCntr;

			    end
			    else if(iCntEn)  
                begin             
				   oCntr   <= oCntr + 1'b1;
                end
			    else  
                begin                          
				   oCntr   <= oCntr; 
    			end
           end		   
     end      
	  
   //-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//	
    assign oCntDone = ( oCntr == MAX_COUNT ) ? 1'b1 : 1'b0;
	  

	 
endmodule
