// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

//`include "pkg-test.v"


module onctl_fix
    (
    input iClk_2M,
    input iRst_n,
	
    input FM_BMC_ONCTL_N,
    input FM_SLPS3_N,
    input FM_BMC_PWRBTN_OUT_N,
    
    output reg FM_BMC_ONCTL_N_LATCH
    );

reg latch_on, FM_BMC_ONCTL_N_LATCH_ff;
reg [31:0] counter;

parameter   T_20S_2M     =  32'd40000000;   

always @ (negedge iRst_n or posedge iClk_2M) begin
    if (!iRst_n) begin
        latch_on <= 1'b0;
        FM_BMC_ONCTL_N_LATCH <= 1'b1;
        FM_BMC_ONCTL_N_LATCH_ff <= 1'b1;
        counter <= 32'd0;
    end
    else begin
        FM_BMC_ONCTL_N_LATCH_ff <= FM_BMC_ONCTL_N;
        if ((!FM_BMC_ONCTL_N_LATCH) & (FM_BMC_ONCTL_N) & (!FM_BMC_PWRBTN_OUT_N))    //Latch is on when PWRBTN_N assertion is detected at pos-edge of ONCTL_N
            latch_on <= 1'b1;
        else if ((!FM_SLPS3_N)|(counter == T_20S_2M))       //Latch is released whenever SLP_S3_N is asserted or watchdog timer reached 20s
            latch_on <= 1'b0;
        else
            latch_on <= latch_on;
        
        if (latch_on) begin
            FM_BMC_ONCTL_N_LATCH <= 1'b0;
            counter <= counter + 1;
        end
        else begin
            FM_BMC_ONCTL_N_LATCH <= FM_BMC_ONCTL_N_LATCH_ff;
            counter <= 32'd0;
        end
    end
end
	
endmodule



