// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

 module reset (
 input pll_locked,
 input iClk_2M,
 output oRst_n
 );

   reg [7:0] rRstCntr=8'b00000000;  //this module is to generate a reliable reset
    reg rIntRst_n;
    always @( posedge iClk_2M or negedge pll_locked) 
    begin
        if (!pll_locked) 
        begin
            rRstCntr <= 8'b0;
            rIntRst_n <= 1'b0;
        end
        else begin
            if (rRstCntr == 8'b11110111) //123 us of reset
            begin
                rIntRst_n <= 1'b1;
    	        rRstCntr <= rRstCntr;
            end

            else begin
                rRstCntr <= rRstCntr + 1'b1;
                rIntRst_n <= 1'b0;
            end
        end
    end

    assign oRst_n = rIntRst_n;

 endmodule
 