`timescale 1ns / 1ps
// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//////////////////////////////////////////////////////////////////////////////////
`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
module uDelay #(parameter TOTAL_BITS = 2)
(
    //% Clock
	input	iClk,
    //% Reset    
	input	iRst,
    //% Clock Enable    
	input	iCE,
    //% Signal to be delayed    
	input	iSignal,
    //% Delayed signal    
	output	oDelayedIn
);
//////////////////////////////////////////////////////////////////////////////////
// Includes
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Defines
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
// Internal Signals
//////////////////////////////////////////////////////////////////////////////////
//!
reg [(TOTAL_BITS-1):0]  rvDlyLine_d;
reg [(TOTAL_BITS-1):0]  rvDlyLine_q;
//////////////////////////////////////////////////////////////////////////////////
// Continous assigments
//////////////////////////////////////////////////////////////////////////////////
assign oDelayedIn = rvDlyLine_q[(TOTAL_BITS-1)];
//////////////////////////////////////////////////////////////////////////////////
// Sequential logic
//////////////////////////////////////////////////////////////////////////////////
always @(posedge iClk)
begin
	if(iRst)
	begin
		rvDlyLine_q	<=	{TOTAL_BITS{iSignal}};
	end
	else
	begin
		if(iCE)
		begin
			rvDlyLine_q	<=	rvDlyLine_d;
		end
		else
		begin
			rvDlyLine_q	<=	rvDlyLine_q;
		end

	end
end
//////////////////////////////////////////////////////////////////////////////////
// Combinational logic
//////////////////////////////////////////////////////////////////////////////////
always @*
begin
	rvDlyLine_d	=	{rvDlyLine_q[(TOTAL_BITS-2):0],iSignal};
end
//////////////////////////////////////////////////////////////////////////////////
// Instances
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
endmodule
