// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

module thermtrip_dly
(
    input  iClk_2M,                   //2MHz Clock Input
    input  iRst_n,
    input  iCpuPwrgdDly,
    input  FM_CPU1_THERMTRIP_LVT3_N,
    input  FM_CPU2_THERMTRIP_LVT3_N,
    input  FM_MEM_THERM_EVENT_CPU1_LVT3_N,
    input  FM_MEM_THERM_EVENT_CPU2_LVT3_N,
    input  FM_CPU2_SKTOCC_LVT3_N,

    output FM_THERMTRIP_DLY
);
    parameter  T_100US_2M  =  32'd200;
    wire wThermtripDly_100us;
    wire wCpuThermtrip_n;

    // Purley changes the memory thermal trip mechanism, and BIOS will set
    // EN_MEMTRIP=0, so CPU thermtrip will not include memory thermtrip, and
    // memory thermtrip is handled by CPLD
    //
    // add mask logic to mask CPU1 thermtrip and CPU1 therm event if CPU1 is
    // not present
    assign wCpuThermtrip_n = FM_CPU1_THERMTRIP_LVT3_N & (FM_CPU2_THERMTRIP_LVT3_N | FM_CPU2_SKTOCC_LVT3_N) & 
                            FM_MEM_THERM_EVENT_CPU1_LVT3_N & ( FM_MEM_THERM_EVENT_CPU2_LVT3_N | FM_CPU2_SKTOCC_LVT3_N )  ;
    assign FM_THERMTRIP_DLY = iCpuPwrgdDly?  (wThermtripDly_100us): 1'b0 ; 
	
    genCntr #( .MAX_COUNT(T_100US_2M)  ) 
    thermtripDelayCounter    
    (
        .oCntDone   (  wThermtripDly_100us ),     // It is high when cnt == MAX_COUNT.   
       
        .iClk         (  iClk_2M     ),  
        .iRst_n       (  iRst_n ),		               
        .iCntEn      (  ~wCpuThermtrip_n),	  
        .iCntRst_n  ( (~wCpuThermtrip_n) | (~wThermtripDly_100us)),
	.oCntr    ( /*empty*/   )
    ); 	 


endmodule
