// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

//***Design Example for volatile key clear and security mode verification****//
//***in MAX 10 through internal JTAG interface (JTAG access from core)**//
		
module JTAG_Lock_Unlock_wysiwyg (
	jtag_core_en, 
	tck_core,
	tdi_core,
	tdo_ignore,
	tdo_core,
	tms_core,
	tck_ignore,
	tdi_ignore,
	tms_ignore
);

input 	jtag_core_en, tck_core, tdi_core, tms_core, tck_ignore, tdi_ignore, tms_ignore;
output	tdo_ignore, tdo_core;

// Define WYSIWYG atoms
//
// WYSIWYG atoms to access JTAG from core

fiftyfivenm_jtag JTAG
(
      .clkdruser(),
		.corectl(jtag_core_en),
		.runidleuser(),
		.shiftuser(),
		.tck(tck_ignore),
		.tckcore(tck_core),
		.tckutap(),
		.tdi(tdi_ignore),
		.tdicore(tdi_core),
		.tdiutap(),
		.tdo(tdo_ignore),
		.tdocore(tdo_core),
		.tdouser(),
		.tdoutap(),
		.tms(tms_ignore),
		.tmscore(tms_core),
		.tmsutap(),
		.updateuser(),
		.usr1user(),
		.ntdopinena()
);


endmodule
