// pfr_sys.v

// Generated using ACDS version 18.1 646

`timescale 1 ps / 1 ps
module pfr_sys (
		output wire        crypto_avmm_clk,                    //            crypto_avmm.clk
		output wire        crypto_avmm_areset,                 //                       .areset
		output wire [6:0]  crypto_avmm_address,                //                       .address
		input  wire        crypto_avmm_waitrequest,            //                       .waitrequest
		output wire        crypto_avmm_read,                   //                       .read
		output wire        crypto_avmm_write,                  //                       .write
		input  wire [31:0] crypto_avmm_readdata,               //                       .readdata
		output wire [31:0] crypto_avmm_writedata,              //                       .writedata
		output wire [31:0] global_state_export,                //           global_state.export
		input  wire [31:0] gpi_1_export,                       //                  gpi_1.export
		output wire [31:0] gpo_1_export,                       //                  gpo_1.export
		output wire        mailbox_avmm_clk,                   //           mailbox_avmm.clk
		output wire        mailbox_avmm_areset,                //                       .areset
		output wire [7:0]  mailbox_avmm_address,               //                       .address
		input  wire        mailbox_avmm_waitrequest,           //                       .waitrequest
		output wire        mailbox_avmm_read,                  //                       .read
		output wire        mailbox_avmm_write,                 //                       .write
		input  wire [31:0] mailbox_avmm_readdata,              //                       .readdata
		output wire [31:0] mailbox_avmm_writedata,             //                       .writedata
		input  wire        mailbox_avmm_readdatavalid,         //                       .readdatavalid
		output wire        relay1_avmm_clk,                    //            relay1_avmm.clk
		output wire        relay1_avmm_areset,                 //                       .areset
		output wire [7:0]  relay1_avmm_address,                //                       .address
		input  wire        relay1_avmm_waitrequest,            //                       .waitrequest
		output wire        relay1_avmm_read,                   //                       .read
		output wire        relay1_avmm_write,                  //                       .write
		input  wire [31:0] relay1_avmm_readdata,               //                       .readdata
		output wire [31:0] relay1_avmm_writedata,              //                       .writedata
		output wire        relay2_avmm_clk,                    //            relay2_avmm.clk
		output wire        relay2_avmm_areset,                 //                       .areset
		output wire [7:0]  relay2_avmm_address,                //                       .address
		input  wire        relay2_avmm_waitrequest,            //                       .waitrequest
		output wire        relay2_avmm_read,                   //                       .read
		output wire        relay2_avmm_write,                  //                       .write
		input  wire [31:0] relay2_avmm_readdata,               //                       .readdata
		output wire [31:0] relay2_avmm_writedata,              //                       .writedata
		output wire        relay3_avmm_clk,                    //            relay3_avmm.clk
		output wire        relay3_avmm_areset,                 //                       .areset
		output wire [7:0]  relay3_avmm_address,                //                       .address
		input  wire        relay3_avmm_waitrequest,            //                       .waitrequest
		output wire        relay3_avmm_read,                   //                       .read
		output wire        relay3_avmm_write,                  //                       .write
		input  wire [31:0] relay3_avmm_readdata,               //                       .readdata
		output wire [31:0] relay3_avmm_writedata,              //                       .writedata
		output wire        rfnvram_avmm_clk,                   //           rfnvram_avmm.clk
		output wire        rfnvram_avmm_areset,                //                       .areset
		output wire [3:0]  rfnvram_avmm_address,               //                       .address
		input  wire        rfnvram_avmm_waitrequest,           //                       .waitrequest
		output wire        rfnvram_avmm_read,                  //                       .read
		output wire        rfnvram_avmm_write,                 //                       .write
		input  wire [31:0] rfnvram_avmm_readdata,              //                       .readdata
		output wire [31:0] rfnvram_avmm_writedata,             //                       .writedata
		input  wire        rfnvram_avmm_readdatavalid,         //                       .readdatavalid
		input  wire        spi_clk_clk,                        //                spi_clk.clk
		input  wire        spi_clk_reset_reset,                //          spi_clk_reset.reset
		output wire        spi_filter_avmm_clk,                //        spi_filter_avmm.clk
		output wire        spi_filter_avmm_areset,             //                       .areset
		output wire [24:0] spi_filter_avmm_address,            //                       .address
		input  wire        spi_filter_avmm_waitrequest,        //                       .waitrequest
		output wire        spi_filter_avmm_read,               //                       .read
		output wire        spi_filter_avmm_write,              //                       .write
		input  wire [31:0] spi_filter_avmm_readdata,           //                       .readdata
		output wire [31:0] spi_filter_avmm_writedata,          //                       .writedata
		input  wire        spi_filter_avmm_readdatavalid,      //                       .readdatavalid
		output wire        spi_filter_bmc_we_avmm_clk,         // spi_filter_bmc_we_avmm.clk
		output wire        spi_filter_bmc_we_avmm_areset,      //                       .areset
		output wire [10:0] spi_filter_bmc_we_avmm_address,     //                       .address
		input  wire        spi_filter_bmc_we_avmm_waitrequest, //                       .waitrequest
		output wire        spi_filter_bmc_we_avmm_read,        //                       .read
		output wire        spi_filter_bmc_we_avmm_write,       //                       .write
		input  wire [31:0] spi_filter_bmc_we_avmm_readdata,    //                       .readdata
		output wire [31:0] spi_filter_bmc_we_avmm_writedata,   //                       .writedata
		output wire        spi_filter_csr_avmm_clk,            //    spi_filter_csr_avmm.clk
		output wire        spi_filter_csr_avmm_areset,         //                       .areset
		output wire [5:0]  spi_filter_csr_avmm_address,        //                       .address
		input  wire        spi_filter_csr_avmm_waitrequest,    //                       .waitrequest
		output wire        spi_filter_csr_avmm_read,           //                       .read
		output wire        spi_filter_csr_avmm_write,          //                       .write
		input  wire [31:0] spi_filter_csr_avmm_readdata,       //                       .readdata
		output wire [31:0] spi_filter_csr_avmm_writedata,      //                       .writedata
		input  wire        spi_filter_csr_avmm_readdatavalid,  //                       .readdatavalid
		output wire        spi_filter_pch_we_avmm_clk,         // spi_filter_pch_we_avmm.clk
		output wire        spi_filter_pch_we_avmm_areset,      //                       .areset
		output wire [10:0] spi_filter_pch_we_avmm_address,     //                       .address
		input  wire        spi_filter_pch_we_avmm_waitrequest, //                       .waitrequest
		output wire        spi_filter_pch_we_avmm_read,        //                       .read
		output wire        spi_filter_pch_we_avmm_write,       //                       .write
		input  wire [31:0] spi_filter_pch_we_avmm_readdata,    //                       .readdata
		output wire [31:0] spi_filter_pch_we_avmm_writedata,   //                       .writedata
		input  wire        sys_clk_clk,                        //                sys_clk.clk
		input  wire        sys_clk_reset_reset,                //          sys_clk_reset.reset
		output wire        timer_bank_avmm_clk,                //        timer_bank_avmm.clk
		output wire        timer_bank_avmm_areset,             //                       .areset
		output wire [10:0] timer_bank_avmm_address,            //                       .address
		input  wire        timer_bank_avmm_waitrequest,        //                       .waitrequest
		output wire        timer_bank_avmm_read,               //                       .read
		output wire        timer_bank_avmm_write,              //                       .write
		input  wire [31:0] timer_bank_avmm_readdata,           //                       .readdata
		output wire [31:0] timer_bank_avmm_writedata           //                       .writedata
	);

	wire  [31:0] u_nios_data_master_readdata;                                         // mm_interconnect_0:u_nios_data_master_readdata -> u_nios:d_readdata
	wire         u_nios_data_master_waitrequest;                                      // mm_interconnect_0:u_nios_data_master_waitrequest -> u_nios:d_waitrequest
	wire         u_nios_data_master_debugaccess;                                      // u_nios:debug_mem_slave_debugaccess_to_roms -> mm_interconnect_0:u_nios_data_master_debugaccess
	wire  [31:0] u_nios_data_master_address;                                          // u_nios:d_address -> mm_interconnect_0:u_nios_data_master_address
	wire   [3:0] u_nios_data_master_byteenable;                                       // u_nios:d_byteenable -> mm_interconnect_0:u_nios_data_master_byteenable
	wire         u_nios_data_master_read;                                             // u_nios:d_read -> mm_interconnect_0:u_nios_data_master_read
	wire         u_nios_data_master_write;                                            // u_nios:d_write -> mm_interconnect_0:u_nios_data_master_write
	wire  [31:0] u_nios_data_master_writedata;                                        // u_nios:d_writedata -> mm_interconnect_0:u_nios_data_master_writedata
	wire  [31:0] u_nios_instruction_master_readdata;                                  // mm_interconnect_0:u_nios_instruction_master_readdata -> u_nios:i_readdata
	wire         u_nios_instruction_master_waitrequest;                               // mm_interconnect_0:u_nios_instruction_master_waitrequest -> u_nios:i_waitrequest
	wire  [31:0] u_nios_instruction_master_address;                                   // u_nios:i_address -> mm_interconnect_0:u_nios_instruction_master_address
	wire         u_nios_instruction_master_read;                                      // u_nios:i_read -> mm_interconnect_0:u_nios_instruction_master_read
	wire  [31:0] mm_interconnect_0_u_dual_config_avalon_readdata;                     // u_dual_config:avmm_rcv_readdata -> mm_interconnect_0:u_dual_config_avalon_readdata
	wire   [2:0] mm_interconnect_0_u_dual_config_avalon_address;                      // mm_interconnect_0:u_dual_config_avalon_address -> u_dual_config:avmm_rcv_address
	wire         mm_interconnect_0_u_dual_config_avalon_read;                         // mm_interconnect_0:u_dual_config_avalon_read -> u_dual_config:avmm_rcv_read
	wire         mm_interconnect_0_u_dual_config_avalon_write;                        // mm_interconnect_0:u_dual_config_avalon_write -> u_dual_config:avmm_rcv_write
	wire  [31:0] mm_interconnect_0_u_dual_config_avalon_writedata;                    // mm_interconnect_0:u_dual_config_avalon_writedata -> u_dual_config:avmm_rcv_writedata
	wire  [31:0] mm_interconnect_0_u_crypto_avmm_bridge_avmm_readdata;                // u_crypto_avmm_bridge:avs_readdata -> mm_interconnect_0:u_crypto_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_crypto_avmm_bridge_avmm_waitrequest;             // u_crypto_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_crypto_avmm_bridge_avmm_waitrequest
	wire   [6:0] mm_interconnect_0_u_crypto_avmm_bridge_avmm_address;                 // mm_interconnect_0:u_crypto_avmm_bridge_avmm_address -> u_crypto_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_crypto_avmm_bridge_avmm_read;                    // mm_interconnect_0:u_crypto_avmm_bridge_avmm_read -> u_crypto_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_crypto_avmm_bridge_avmm_write;                   // mm_interconnect_0:u_crypto_avmm_bridge_avmm_write -> u_crypto_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_crypto_avmm_bridge_avmm_writedata;               // mm_interconnect_0:u_crypto_avmm_bridge_avmm_writedata -> u_crypto_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_relay1_avmm_bridge_avmm_readdata;                // u_relay1_avmm_bridge:avs_readdata -> mm_interconnect_0:u_relay1_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_relay1_avmm_bridge_avmm_waitrequest;             // u_relay1_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_relay1_avmm_bridge_avmm_waitrequest
	wire   [7:0] mm_interconnect_0_u_relay1_avmm_bridge_avmm_address;                 // mm_interconnect_0:u_relay1_avmm_bridge_avmm_address -> u_relay1_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_relay1_avmm_bridge_avmm_read;                    // mm_interconnect_0:u_relay1_avmm_bridge_avmm_read -> u_relay1_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_relay1_avmm_bridge_avmm_write;                   // mm_interconnect_0:u_relay1_avmm_bridge_avmm_write -> u_relay1_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_relay1_avmm_bridge_avmm_writedata;               // mm_interconnect_0:u_relay1_avmm_bridge_avmm_writedata -> u_relay1_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_readdata;      // u_spi_filter_csr_avmm_bridge_0:avs_readdata -> mm_interconnect_0:u_spi_filter_csr_avmm_bridge_0_avmm_readdata
	wire         mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_waitrequest;   // u_spi_filter_csr_avmm_bridge_0:avs_waitrequest -> mm_interconnect_0:u_spi_filter_csr_avmm_bridge_0_avmm_waitrequest
	wire   [5:0] mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_address;       // mm_interconnect_0:u_spi_filter_csr_avmm_bridge_0_avmm_address -> u_spi_filter_csr_avmm_bridge_0:avs_address
	wire         mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_read;          // mm_interconnect_0:u_spi_filter_csr_avmm_bridge_0_avmm_read -> u_spi_filter_csr_avmm_bridge_0:avs_read
	wire         mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_readdatavalid; // u_spi_filter_csr_avmm_bridge_0:avs_readdatavalid -> mm_interconnect_0:u_spi_filter_csr_avmm_bridge_0_avmm_readdatavalid
	wire         mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_write;         // mm_interconnect_0:u_spi_filter_csr_avmm_bridge_0_avmm_write -> u_spi_filter_csr_avmm_bridge_0:avs_write
	wire  [31:0] mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_writedata;     // mm_interconnect_0:u_spi_filter_csr_avmm_bridge_0_avmm_writedata -> u_spi_filter_csr_avmm_bridge_0:avs_writedata
	wire  [31:0] mm_interconnect_0_u_relay2_avmm_bridge_avmm_readdata;                // u_relay2_avmm_bridge:avs_readdata -> mm_interconnect_0:u_relay2_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_relay2_avmm_bridge_avmm_waitrequest;             // u_relay2_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_relay2_avmm_bridge_avmm_waitrequest
	wire   [7:0] mm_interconnect_0_u_relay2_avmm_bridge_avmm_address;                 // mm_interconnect_0:u_relay2_avmm_bridge_avmm_address -> u_relay2_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_relay2_avmm_bridge_avmm_read;                    // mm_interconnect_0:u_relay2_avmm_bridge_avmm_read -> u_relay2_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_relay2_avmm_bridge_avmm_write;                   // mm_interconnect_0:u_relay2_avmm_bridge_avmm_write -> u_relay2_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_relay2_avmm_bridge_avmm_writedata;               // mm_interconnect_0:u_relay2_avmm_bridge_avmm_writedata -> u_relay2_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_relay3_avmm_bridge_avmm_readdata;                // u_relay3_avmm_bridge:avs_readdata -> mm_interconnect_0:u_relay3_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_relay3_avmm_bridge_avmm_waitrequest;             // u_relay3_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_relay3_avmm_bridge_avmm_waitrequest
	wire   [7:0] mm_interconnect_0_u_relay3_avmm_bridge_avmm_address;                 // mm_interconnect_0:u_relay3_avmm_bridge_avmm_address -> u_relay3_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_relay3_avmm_bridge_avmm_read;                    // mm_interconnect_0:u_relay3_avmm_bridge_avmm_read -> u_relay3_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_relay3_avmm_bridge_avmm_write;                   // mm_interconnect_0:u_relay3_avmm_bridge_avmm_write -> u_relay3_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_relay3_avmm_bridge_avmm_writedata;               // mm_interconnect_0:u_relay3_avmm_bridge_avmm_writedata -> u_relay3_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_mailbox_avmm_bridge_avmm_readdata;               // u_mailbox_avmm_bridge:avs_readdata -> mm_interconnect_0:u_mailbox_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_mailbox_avmm_bridge_avmm_waitrequest;            // u_mailbox_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_mailbox_avmm_bridge_avmm_waitrequest
	wire   [7:0] mm_interconnect_0_u_mailbox_avmm_bridge_avmm_address;                // mm_interconnect_0:u_mailbox_avmm_bridge_avmm_address -> u_mailbox_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_mailbox_avmm_bridge_avmm_read;                   // mm_interconnect_0:u_mailbox_avmm_bridge_avmm_read -> u_mailbox_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_mailbox_avmm_bridge_avmm_readdatavalid;          // u_mailbox_avmm_bridge:avs_readdatavalid -> mm_interconnect_0:u_mailbox_avmm_bridge_avmm_readdatavalid
	wire         mm_interconnect_0_u_mailbox_avmm_bridge_avmm_write;                  // mm_interconnect_0:u_mailbox_avmm_bridge_avmm_write -> u_mailbox_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_mailbox_avmm_bridge_avmm_writedata;              // mm_interconnect_0:u_mailbox_avmm_bridge_avmm_writedata -> u_mailbox_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_rfnvram_smbus_master_avmm_readdata;              // u_rfnvram_smbus_master:avs_readdata -> mm_interconnect_0:u_rfnvram_smbus_master_avmm_readdata
	wire         mm_interconnect_0_u_rfnvram_smbus_master_avmm_waitrequest;           // u_rfnvram_smbus_master:avs_waitrequest -> mm_interconnect_0:u_rfnvram_smbus_master_avmm_waitrequest
	wire   [3:0] mm_interconnect_0_u_rfnvram_smbus_master_avmm_address;               // mm_interconnect_0:u_rfnvram_smbus_master_avmm_address -> u_rfnvram_smbus_master:avs_address
	wire         mm_interconnect_0_u_rfnvram_smbus_master_avmm_read;                  // mm_interconnect_0:u_rfnvram_smbus_master_avmm_read -> u_rfnvram_smbus_master:avs_read
	wire         mm_interconnect_0_u_rfnvram_smbus_master_avmm_readdatavalid;         // u_rfnvram_smbus_master:avs_readdatavalid -> mm_interconnect_0:u_rfnvram_smbus_master_avmm_readdatavalid
	wire         mm_interconnect_0_u_rfnvram_smbus_master_avmm_write;                 // mm_interconnect_0:u_rfnvram_smbus_master_avmm_write -> u_rfnvram_smbus_master:avs_write
	wire  [31:0] mm_interconnect_0_u_rfnvram_smbus_master_avmm_writedata;             // mm_interconnect_0:u_rfnvram_smbus_master_avmm_writedata -> u_rfnvram_smbus_master:avs_writedata
	wire  [31:0] mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_readdata;     // u_spi_filter_bmc_we_avmm_bridge:avs_readdata -> mm_interconnect_0:u_spi_filter_bmc_we_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_waitrequest;  // u_spi_filter_bmc_we_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_spi_filter_bmc_we_avmm_bridge_avmm_waitrequest
	wire  [10:0] mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_address;      // mm_interconnect_0:u_spi_filter_bmc_we_avmm_bridge_avmm_address -> u_spi_filter_bmc_we_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_read;         // mm_interconnect_0:u_spi_filter_bmc_we_avmm_bridge_avmm_read -> u_spi_filter_bmc_we_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_write;        // mm_interconnect_0:u_spi_filter_bmc_we_avmm_bridge_avmm_write -> u_spi_filter_bmc_we_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_writedata;    // mm_interconnect_0:u_spi_filter_bmc_we_avmm_bridge_avmm_writedata -> u_spi_filter_bmc_we_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_readdata;            // u_spi_filter_avmm_bridge:avs_readdata -> mm_interconnect_0:u_spi_filter_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_waitrequest;         // u_spi_filter_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_spi_filter_avmm_bridge_avmm_waitrequest
	wire  [24:0] mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_address;             // mm_interconnect_0:u_spi_filter_avmm_bridge_avmm_address -> u_spi_filter_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_read;                // mm_interconnect_0:u_spi_filter_avmm_bridge_avmm_read -> u_spi_filter_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_readdatavalid;       // u_spi_filter_avmm_bridge:avs_readdatavalid -> mm_interconnect_0:u_spi_filter_avmm_bridge_avmm_readdatavalid
	wire         mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_write;               // mm_interconnect_0:u_spi_filter_avmm_bridge_avmm_write -> u_spi_filter_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_writedata;           // mm_interconnect_0:u_spi_filter_avmm_bridge_avmm_writedata -> u_spi_filter_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_readdata;     // u_spi_filter_pch_we_avmm_bridge:avs_readdata -> mm_interconnect_0:u_spi_filter_pch_we_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_waitrequest;  // u_spi_filter_pch_we_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_spi_filter_pch_we_avmm_bridge_avmm_waitrequest
	wire  [10:0] mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_address;      // mm_interconnect_0:u_spi_filter_pch_we_avmm_bridge_avmm_address -> u_spi_filter_pch_we_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_read;         // mm_interconnect_0:u_spi_filter_pch_we_avmm_bridge_avmm_read -> u_spi_filter_pch_we_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_write;        // mm_interconnect_0:u_spi_filter_pch_we_avmm_bridge_avmm_write -> u_spi_filter_pch_we_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_writedata;    // mm_interconnect_0:u_spi_filter_pch_we_avmm_bridge_avmm_writedata -> u_spi_filter_pch_we_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_readdata;            // u_timer_bank_avmm_bridge:avs_readdata -> mm_interconnect_0:u_timer_bank_avmm_bridge_avmm_readdata
	wire         mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_waitrequest;         // u_timer_bank_avmm_bridge:avs_waitrequest -> mm_interconnect_0:u_timer_bank_avmm_bridge_avmm_waitrequest
	wire  [10:0] mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_address;             // mm_interconnect_0:u_timer_bank_avmm_bridge_avmm_address -> u_timer_bank_avmm_bridge:avs_address
	wire         mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_read;                // mm_interconnect_0:u_timer_bank_avmm_bridge_avmm_read -> u_timer_bank_avmm_bridge:avs_read
	wire         mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_write;               // mm_interconnect_0:u_timer_bank_avmm_bridge_avmm_write -> u_timer_bank_avmm_bridge:avs_write
	wire  [31:0] mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_writedata;           // mm_interconnect_0:u_timer_bank_avmm_bridge_avmm_writedata -> u_timer_bank_avmm_bridge:avs_writedata
	wire  [31:0] mm_interconnect_0_u_ufm_csr_readdata;                                // u_ufm:avmm_csr_readdata -> mm_interconnect_0:u_ufm_csr_readdata
	wire   [0:0] mm_interconnect_0_u_ufm_csr_address;                                 // mm_interconnect_0:u_ufm_csr_address -> u_ufm:avmm_csr_addr
	wire         mm_interconnect_0_u_ufm_csr_read;                                    // mm_interconnect_0:u_ufm_csr_read -> u_ufm:avmm_csr_read
	wire         mm_interconnect_0_u_ufm_csr_write;                                   // mm_interconnect_0:u_ufm_csr_write -> u_ufm:avmm_csr_write
	wire  [31:0] mm_interconnect_0_u_ufm_csr_writedata;                               // mm_interconnect_0:u_ufm_csr_writedata -> u_ufm:avmm_csr_writedata
	wire  [31:0] mm_interconnect_0_u_ufm_data_readdata;                               // u_ufm:avmm_data_readdata -> mm_interconnect_0:u_ufm_data_readdata
	wire         mm_interconnect_0_u_ufm_data_waitrequest;                            // u_ufm:avmm_data_waitrequest -> mm_interconnect_0:u_ufm_data_waitrequest
	wire  [17:0] mm_interconnect_0_u_ufm_data_address;                                // mm_interconnect_0:u_ufm_data_address -> u_ufm:avmm_data_addr
	wire         mm_interconnect_0_u_ufm_data_read;                                   // mm_interconnect_0:u_ufm_data_read -> u_ufm:avmm_data_read
	wire         mm_interconnect_0_u_ufm_data_readdatavalid;                          // u_ufm:avmm_data_readdatavalid -> mm_interconnect_0:u_ufm_data_readdatavalid
	wire         mm_interconnect_0_u_ufm_data_write;                                  // mm_interconnect_0:u_ufm_data_write -> u_ufm:avmm_data_write
	wire  [31:0] mm_interconnect_0_u_ufm_data_writedata;                              // mm_interconnect_0:u_ufm_data_writedata -> u_ufm:avmm_data_writedata
	wire   [1:0] mm_interconnect_0_u_ufm_data_burstcount;                             // mm_interconnect_0:u_ufm_data_burstcount -> u_ufm:avmm_data_burstcount
	wire  [31:0] mm_interconnect_0_u_nios_debug_mem_slave_readdata;                   // u_nios:debug_mem_slave_readdata -> mm_interconnect_0:u_nios_debug_mem_slave_readdata
	wire         mm_interconnect_0_u_nios_debug_mem_slave_waitrequest;                // u_nios:debug_mem_slave_waitrequest -> mm_interconnect_0:u_nios_debug_mem_slave_waitrequest
	wire         mm_interconnect_0_u_nios_debug_mem_slave_debugaccess;                // mm_interconnect_0:u_nios_debug_mem_slave_debugaccess -> u_nios:debug_mem_slave_debugaccess
	wire   [8:0] mm_interconnect_0_u_nios_debug_mem_slave_address;                    // mm_interconnect_0:u_nios_debug_mem_slave_address -> u_nios:debug_mem_slave_address
	wire         mm_interconnect_0_u_nios_debug_mem_slave_read;                       // mm_interconnect_0:u_nios_debug_mem_slave_read -> u_nios:debug_mem_slave_read
	wire   [3:0] mm_interconnect_0_u_nios_debug_mem_slave_byteenable;                 // mm_interconnect_0:u_nios_debug_mem_slave_byteenable -> u_nios:debug_mem_slave_byteenable
	wire         mm_interconnect_0_u_nios_debug_mem_slave_write;                      // mm_interconnect_0:u_nios_debug_mem_slave_write -> u_nios:debug_mem_slave_write
	wire  [31:0] mm_interconnect_0_u_nios_debug_mem_slave_writedata;                  // mm_interconnect_0:u_nios_debug_mem_slave_writedata -> u_nios:debug_mem_slave_writedata
	wire         mm_interconnect_0_u_nios_ram_s1_chipselect;                          // mm_interconnect_0:u_nios_ram_s1_chipselect -> u_nios_ram:chipselect
	wire  [31:0] mm_interconnect_0_u_nios_ram_s1_readdata;                            // u_nios_ram:readdata -> mm_interconnect_0:u_nios_ram_s1_readdata
	wire  [11:0] mm_interconnect_0_u_nios_ram_s1_address;                             // mm_interconnect_0:u_nios_ram_s1_address -> u_nios_ram:address
	wire   [3:0] mm_interconnect_0_u_nios_ram_s1_byteenable;                          // mm_interconnect_0:u_nios_ram_s1_byteenable -> u_nios_ram:byteenable
	wire         mm_interconnect_0_u_nios_ram_s1_write;                               // mm_interconnect_0:u_nios_ram_s1_write -> u_nios_ram:write
	wire  [31:0] mm_interconnect_0_u_nios_ram_s1_writedata;                           // mm_interconnect_0:u_nios_ram_s1_writedata -> u_nios_ram:writedata
	wire         mm_interconnect_0_u_nios_ram_s1_clken;                               // mm_interconnect_0:u_nios_ram_s1_clken -> u_nios_ram:clken
	wire         mm_interconnect_0_u_global_state_reg_s1_chipselect;                  // mm_interconnect_0:u_global_state_reg_s1_chipselect -> u_global_state_reg:chipselect
	wire  [31:0] mm_interconnect_0_u_global_state_reg_s1_readdata;                    // u_global_state_reg:readdata -> mm_interconnect_0:u_global_state_reg_s1_readdata
	wire   [1:0] mm_interconnect_0_u_global_state_reg_s1_address;                     // mm_interconnect_0:u_global_state_reg_s1_address -> u_global_state_reg:address
	wire         mm_interconnect_0_u_global_state_reg_s1_write;                       // mm_interconnect_0:u_global_state_reg_s1_write -> u_global_state_reg:write_n
	wire  [31:0] mm_interconnect_0_u_global_state_reg_s1_writedata;                   // mm_interconnect_0:u_global_state_reg_s1_writedata -> u_global_state_reg:writedata
	wire         mm_interconnect_0_u_gpo_1_s1_chipselect;                             // mm_interconnect_0:u_gpo_1_s1_chipselect -> u_gpo_1:chipselect
	wire  [31:0] mm_interconnect_0_u_gpo_1_s1_readdata;                               // u_gpo_1:readdata -> mm_interconnect_0:u_gpo_1_s1_readdata
	wire   [1:0] mm_interconnect_0_u_gpo_1_s1_address;                                // mm_interconnect_0:u_gpo_1_s1_address -> u_gpo_1:address
	wire         mm_interconnect_0_u_gpo_1_s1_write;                                  // mm_interconnect_0:u_gpo_1_s1_write -> u_gpo_1:write_n
	wire  [31:0] mm_interconnect_0_u_gpo_1_s1_writedata;                              // mm_interconnect_0:u_gpo_1_s1_writedata -> u_gpo_1:writedata
	wire  [31:0] mm_interconnect_0_u_gpi_1_s1_readdata;                               // u_gpi_1:readdata -> mm_interconnect_0:u_gpi_1_s1_readdata
	wire   [1:0] mm_interconnect_0_u_gpi_1_s1_address;                                // mm_interconnect_0:u_gpi_1_s1_address -> u_gpi_1:address
	wire  [31:0] u_nios_irq_irq;                                                      // irq_mapper:sender_irq -> u_nios:irq
	wire         rst_controller_reset_out_reset;                                      // rst_controller:reset_out -> [irq_mapper:reset, mm_interconnect_0:u_nios_reset_reset_bridge_in_reset_reset, rst_translator:in_reset, u_crypto_avmm_bridge:areset, u_dual_config:nreset, u_global_state_reg:reset_n, u_gpi_1:reset_n, u_gpo_1:reset_n, u_mailbox_avmm_bridge:areset, u_nios:reset_n, u_nios_ram:reset, u_relay1_avmm_bridge:areset, u_relay2_avmm_bridge:areset, u_relay3_avmm_bridge:areset, u_rfnvram_smbus_master:areset, u_spi_filter_bmc_we_avmm_bridge:areset, u_spi_filter_pch_we_avmm_bridge:areset, u_timer_bank_avmm_bridge:areset, u_ufm:reset_n]
	wire         rst_controller_reset_out_reset_req;                                  // rst_controller:reset_req -> [rst_translator:reset_req_in, u_nios_ram:reset_req]

	basic_avmm_bridge #(
		.ADDRESS_WIDTH (7)
	) u_crypto_avmm_bridge (
		.clk             (sys_clk_clk),                                             //         clk.clk
		.areset          (rst_controller_reset_out_reset),                          //       reset.reset
		.avm_clk         (crypto_avmm_clk),                                         // conduit_end.clk
		.avm_areset      (crypto_avmm_areset),                                      //            .areset
		.avm_address     (crypto_avmm_address),                                     //            .address
		.avm_waitrequest (crypto_avmm_waitrequest),                                 //            .waitrequest
		.avm_read        (crypto_avmm_read),                                        //            .read
		.avm_write       (crypto_avmm_write),                                       //            .write
		.avm_readdata    (crypto_avmm_readdata),                                    //            .readdata
		.avm_writedata   (crypto_avmm_writedata),                                   //            .writedata
		.avs_address     (mm_interconnect_0_u_crypto_avmm_bridge_avmm_address),     //        avmm.address
		.avs_waitrequest (mm_interconnect_0_u_crypto_avmm_bridge_avmm_waitrequest), //            .waitrequest
		.avs_read        (mm_interconnect_0_u_crypto_avmm_bridge_avmm_read),        //            .read
		.avs_write       (mm_interconnect_0_u_crypto_avmm_bridge_avmm_write),       //            .write
		.avs_readdata    (mm_interconnect_0_u_crypto_avmm_bridge_avmm_readdata),    //            .readdata
		.avs_writedata   (mm_interconnect_0_u_crypto_avmm_bridge_avmm_writedata)    //            .writedata
	);

	altera_dual_boot #(
		.INTENDED_DEVICE_FAMILY ("MAX 10"),
		.CONFIG_CYCLE           (29),
		.RESET_TIMER_CYCLE      (41)
	) u_dual_config (
		.clk                (sys_clk_clk),                                      //    clk.clk
		.nreset             (~rst_controller_reset_out_reset),                  // nreset.reset_n
		.avmm_rcv_address   (mm_interconnect_0_u_dual_config_avalon_address),   // avalon.address
		.avmm_rcv_read      (mm_interconnect_0_u_dual_config_avalon_read),      //       .read
		.avmm_rcv_writedata (mm_interconnect_0_u_dual_config_avalon_writedata), //       .writedata
		.avmm_rcv_write     (mm_interconnect_0_u_dual_config_avalon_write),     //       .write
		.avmm_rcv_readdata  (mm_interconnect_0_u_dual_config_avalon_readdata)   //       .readdata
	);

	pfr_sys_u_global_state_reg u_global_state_reg (
		.clk        (sys_clk_clk),                                        //                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),                    //               reset.reset_n
		.address    (mm_interconnect_0_u_global_state_reg_s1_address),    //                  s1.address
		.write_n    (~mm_interconnect_0_u_global_state_reg_s1_write),     //                    .write_n
		.writedata  (mm_interconnect_0_u_global_state_reg_s1_writedata),  //                    .writedata
		.chipselect (mm_interconnect_0_u_global_state_reg_s1_chipselect), //                    .chipselect
		.readdata   (mm_interconnect_0_u_global_state_reg_s1_readdata),   //                    .readdata
		.out_port   (global_state_export)                                 // external_connection.export
	);

	pfr_sys_u_gpi_1 u_gpi_1 (
		.clk      (sys_clk_clk),                           //                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),       //               reset.reset_n
		.address  (mm_interconnect_0_u_gpi_1_s1_address),  //                  s1.address
		.readdata (mm_interconnect_0_u_gpi_1_s1_readdata), //                    .readdata
		.in_port  (gpi_1_export)                           // external_connection.export
	);

	pfr_sys_u_global_state_reg u_gpo_1 (
		.clk        (sys_clk_clk),                             //                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),         //               reset.reset_n
		.address    (mm_interconnect_0_u_gpo_1_s1_address),    //                  s1.address
		.write_n    (~mm_interconnect_0_u_gpo_1_s1_write),     //                    .write_n
		.writedata  (mm_interconnect_0_u_gpo_1_s1_writedata),  //                    .writedata
		.chipselect (mm_interconnect_0_u_gpo_1_s1_chipselect), //                    .chipselect
		.readdata   (mm_interconnect_0_u_gpo_1_s1_readdata),   //                    .readdata
		.out_port   (gpo_1_export)                             // external_connection.export
	);

	basic_avmm_bridge_rdv #(
		.ADDRESS_WIDTH (8)
	) u_mailbox_avmm_bridge (
		.clk               (sys_clk_clk),                                                //         clk.clk
		.areset            (rst_controller_reset_out_reset),                             //       reset.reset
		.avm_clk           (mailbox_avmm_clk),                                           // conduit_end.clk
		.avm_areset        (mailbox_avmm_areset),                                        //            .areset
		.avm_address       (mailbox_avmm_address),                                       //            .address
		.avm_waitrequest   (mailbox_avmm_waitrequest),                                   //            .waitrequest
		.avm_read          (mailbox_avmm_read),                                          //            .read
		.avm_write         (mailbox_avmm_write),                                         //            .write
		.avm_readdata      (mailbox_avmm_readdata),                                      //            .readdata
		.avm_writedata     (mailbox_avmm_writedata),                                     //            .writedata
		.avm_readdatavalid (mailbox_avmm_readdatavalid),                                 //            .readdatavalid
		.avs_address       (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_address),       //        avmm.address
		.avs_waitrequest   (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_waitrequest),   //            .waitrequest
		.avs_read          (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_read),          //            .read
		.avs_write         (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_write),         //            .write
		.avs_readdata      (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_readdata),      //            .readdata
		.avs_writedata     (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_writedata),     //            .writedata
		.avs_readdatavalid (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_readdatavalid)  //            .readdatavalid
	);

	pfr_sys_u_nios u_nios (
		.clk                                 (sys_clk_clk),                                          //                       clk.clk
		.reset_n                             (~rst_controller_reset_out_reset),                      //                     reset.reset_n
		.d_address                           (u_nios_data_master_address),                           //               data_master.address
		.d_byteenable                        (u_nios_data_master_byteenable),                        //                          .byteenable
		.d_read                              (u_nios_data_master_read),                              //                          .read
		.d_readdata                          (u_nios_data_master_readdata),                          //                          .readdata
		.d_waitrequest                       (u_nios_data_master_waitrequest),                       //                          .waitrequest
		.d_write                             (u_nios_data_master_write),                             //                          .write
		.d_writedata                         (u_nios_data_master_writedata),                         //                          .writedata
		.debug_mem_slave_debugaccess_to_roms (u_nios_data_master_debugaccess),                       //                          .debugaccess
		.i_address                           (u_nios_instruction_master_address),                    //        instruction_master.address
		.i_read                              (u_nios_instruction_master_read),                       //                          .read
		.i_readdata                          (u_nios_instruction_master_readdata),                   //                          .readdata
		.i_waitrequest                       (u_nios_instruction_master_waitrequest),                //                          .waitrequest
		.irq                                 (u_nios_irq_irq),                                       //                       irq.irq
		.debug_reset_request                 (),                                                     //       debug_reset_request.reset
		.debug_mem_slave_address             (mm_interconnect_0_u_nios_debug_mem_slave_address),     //           debug_mem_slave.address
		.debug_mem_slave_byteenable          (mm_interconnect_0_u_nios_debug_mem_slave_byteenable),  //                          .byteenable
		.debug_mem_slave_debugaccess         (mm_interconnect_0_u_nios_debug_mem_slave_debugaccess), //                          .debugaccess
		.debug_mem_slave_read                (mm_interconnect_0_u_nios_debug_mem_slave_read),        //                          .read
		.debug_mem_slave_readdata            (mm_interconnect_0_u_nios_debug_mem_slave_readdata),    //                          .readdata
		.debug_mem_slave_waitrequest         (mm_interconnect_0_u_nios_debug_mem_slave_waitrequest), //                          .waitrequest
		.debug_mem_slave_write               (mm_interconnect_0_u_nios_debug_mem_slave_write),       //                          .write
		.debug_mem_slave_writedata           (mm_interconnect_0_u_nios_debug_mem_slave_writedata),   //                          .writedata
		.dummy_ci_port                       ()                                                      // custom_instruction_master.readra
	);

	pfr_sys_u_nios_ram u_nios_ram (
		.clk        (sys_clk_clk),                                //   clk1.clk
		.address    (mm_interconnect_0_u_nios_ram_s1_address),    //     s1.address
		.clken      (mm_interconnect_0_u_nios_ram_s1_clken),      //       .clken
		.chipselect (mm_interconnect_0_u_nios_ram_s1_chipselect), //       .chipselect
		.write      (mm_interconnect_0_u_nios_ram_s1_write),      //       .write
		.readdata   (mm_interconnect_0_u_nios_ram_s1_readdata),   //       .readdata
		.writedata  (mm_interconnect_0_u_nios_ram_s1_writedata),  //       .writedata
		.byteenable (mm_interconnect_0_u_nios_ram_s1_byteenable), //       .byteenable
		.reset      (rst_controller_reset_out_reset),             // reset1.reset
		.reset_req  (rst_controller_reset_out_reset_req),         //       .reset_req
		.freeze     (1'b0)                                        // (terminated)
	);

	basic_avmm_bridge #(
		.ADDRESS_WIDTH (8)
	) u_relay1_avmm_bridge (
		.clk             (sys_clk_clk),                                             //         clk.clk
		.areset          (rst_controller_reset_out_reset),                          //       reset.reset
		.avm_clk         (relay1_avmm_clk),                                         // conduit_end.clk
		.avm_areset      (relay1_avmm_areset),                                      //            .areset
		.avm_address     (relay1_avmm_address),                                     //            .address
		.avm_waitrequest (relay1_avmm_waitrequest),                                 //            .waitrequest
		.avm_read        (relay1_avmm_read),                                        //            .read
		.avm_write       (relay1_avmm_write),                                       //            .write
		.avm_readdata    (relay1_avmm_readdata),                                    //            .readdata
		.avm_writedata   (relay1_avmm_writedata),                                   //            .writedata
		.avs_address     (mm_interconnect_0_u_relay1_avmm_bridge_avmm_address),     //        avmm.address
		.avs_waitrequest (mm_interconnect_0_u_relay1_avmm_bridge_avmm_waitrequest), //            .waitrequest
		.avs_read        (mm_interconnect_0_u_relay1_avmm_bridge_avmm_read),        //            .read
		.avs_write       (mm_interconnect_0_u_relay1_avmm_bridge_avmm_write),       //            .write
		.avs_readdata    (mm_interconnect_0_u_relay1_avmm_bridge_avmm_readdata),    //            .readdata
		.avs_writedata   (mm_interconnect_0_u_relay1_avmm_bridge_avmm_writedata)    //            .writedata
	);

	basic_avmm_bridge #(
		.ADDRESS_WIDTH (8)
	) u_relay2_avmm_bridge (
		.clk             (sys_clk_clk),                                             //         clk.clk
		.areset          (rst_controller_reset_out_reset),                          //       reset.reset
		.avm_clk         (relay2_avmm_clk),                                         // conduit_end.clk
		.avm_areset      (relay2_avmm_areset),                                      //            .areset
		.avm_address     (relay2_avmm_address),                                     //            .address
		.avm_waitrequest (relay2_avmm_waitrequest),                                 //            .waitrequest
		.avm_read        (relay2_avmm_read),                                        //            .read
		.avm_write       (relay2_avmm_write),                                       //            .write
		.avm_readdata    (relay2_avmm_readdata),                                    //            .readdata
		.avm_writedata   (relay2_avmm_writedata),                                   //            .writedata
		.avs_address     (mm_interconnect_0_u_relay2_avmm_bridge_avmm_address),     //        avmm.address
		.avs_waitrequest (mm_interconnect_0_u_relay2_avmm_bridge_avmm_waitrequest), //            .waitrequest
		.avs_read        (mm_interconnect_0_u_relay2_avmm_bridge_avmm_read),        //            .read
		.avs_write       (mm_interconnect_0_u_relay2_avmm_bridge_avmm_write),       //            .write
		.avs_readdata    (mm_interconnect_0_u_relay2_avmm_bridge_avmm_readdata),    //            .readdata
		.avs_writedata   (mm_interconnect_0_u_relay2_avmm_bridge_avmm_writedata)    //            .writedata
	);

	basic_avmm_bridge #(
		.ADDRESS_WIDTH (8)
	) u_relay3_avmm_bridge (
		.clk             (sys_clk_clk),                                             //         clk.clk
		.areset          (rst_controller_reset_out_reset),                          //       reset.reset
		.avm_clk         (relay3_avmm_clk),                                         // conduit_end.clk
		.avm_areset      (relay3_avmm_areset),                                      //            .areset
		.avm_address     (relay3_avmm_address),                                     //            .address
		.avm_waitrequest (relay3_avmm_waitrequest),                                 //            .waitrequest
		.avm_read        (relay3_avmm_read),                                        //            .read
		.avm_write       (relay3_avmm_write),                                       //            .write
		.avm_readdata    (relay3_avmm_readdata),                                    //            .readdata
		.avm_writedata   (relay3_avmm_writedata),                                   //            .writedata
		.avs_address     (mm_interconnect_0_u_relay3_avmm_bridge_avmm_address),     //        avmm.address
		.avs_waitrequest (mm_interconnect_0_u_relay3_avmm_bridge_avmm_waitrequest), //            .waitrequest
		.avs_read        (mm_interconnect_0_u_relay3_avmm_bridge_avmm_read),        //            .read
		.avs_write       (mm_interconnect_0_u_relay3_avmm_bridge_avmm_write),       //            .write
		.avs_readdata    (mm_interconnect_0_u_relay3_avmm_bridge_avmm_readdata),    //            .readdata
		.avs_writedata   (mm_interconnect_0_u_relay3_avmm_bridge_avmm_writedata)    //            .writedata
	);

	basic_avmm_bridge_rdv #(
		.ADDRESS_WIDTH (4)
	) u_rfnvram_smbus_master (
		.clk               (sys_clk_clk),                                                 //         clk.clk
		.areset            (rst_controller_reset_out_reset),                              //       reset.reset
		.avm_clk           (rfnvram_avmm_clk),                                            // conduit_end.clk
		.avm_areset        (rfnvram_avmm_areset),                                         //            .areset
		.avm_address       (rfnvram_avmm_address),                                        //            .address
		.avm_waitrequest   (rfnvram_avmm_waitrequest),                                    //            .waitrequest
		.avm_read          (rfnvram_avmm_read),                                           //            .read
		.avm_write         (rfnvram_avmm_write),                                          //            .write
		.avm_readdata      (rfnvram_avmm_readdata),                                       //            .readdata
		.avm_writedata     (rfnvram_avmm_writedata),                                      //            .writedata
		.avm_readdatavalid (rfnvram_avmm_readdatavalid),                                  //            .readdatavalid
		.avs_address       (mm_interconnect_0_u_rfnvram_smbus_master_avmm_address),       //        avmm.address
		.avs_waitrequest   (mm_interconnect_0_u_rfnvram_smbus_master_avmm_waitrequest),   //            .waitrequest
		.avs_read          (mm_interconnect_0_u_rfnvram_smbus_master_avmm_read),          //            .read
		.avs_write         (mm_interconnect_0_u_rfnvram_smbus_master_avmm_write),         //            .write
		.avs_readdata      (mm_interconnect_0_u_rfnvram_smbus_master_avmm_readdata),      //            .readdata
		.avs_writedata     (mm_interconnect_0_u_rfnvram_smbus_master_avmm_writedata),     //            .writedata
		.avs_readdatavalid (mm_interconnect_0_u_rfnvram_smbus_master_avmm_readdatavalid)  //            .readdatavalid
	);

	basic_avmm_bridge_rdv #(
		.ADDRESS_WIDTH (25)
	) u_spi_filter_avmm_bridge (
		.clk               (spi_clk_clk),                                                   //         clk.clk
		.areset            (spi_clk_reset_reset),                                           //       reset.reset
		.avm_clk           (spi_filter_avmm_clk),                                           // conduit_end.clk
		.avm_areset        (spi_filter_avmm_areset),                                        //            .areset
		.avm_address       (spi_filter_avmm_address),                                       //            .address
		.avm_waitrequest   (spi_filter_avmm_waitrequest),                                   //            .waitrequest
		.avm_read          (spi_filter_avmm_read),                                          //            .read
		.avm_write         (spi_filter_avmm_write),                                         //            .write
		.avm_readdata      (spi_filter_avmm_readdata),                                      //            .readdata
		.avm_writedata     (spi_filter_avmm_writedata),                                     //            .writedata
		.avm_readdatavalid (spi_filter_avmm_readdatavalid),                                 //            .readdatavalid
		.avs_address       (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_address),       //        avmm.address
		.avs_waitrequest   (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_waitrequest),   //            .waitrequest
		.avs_read          (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_read),          //            .read
		.avs_write         (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_write),         //            .write
		.avs_readdata      (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_readdata),      //            .readdata
		.avs_writedata     (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_writedata),     //            .writedata
		.avs_readdatavalid (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_readdatavalid)  //            .readdatavalid
	);

	basic_avmm_bridge #(
		.ADDRESS_WIDTH (11)
	) u_spi_filter_bmc_we_avmm_bridge (
		.clk             (sys_clk_clk),                                                        //         clk.clk
		.areset          (rst_controller_reset_out_reset),                                     //       reset.reset
		.avm_clk         (spi_filter_bmc_we_avmm_clk),                                         // conduit_end.clk
		.avm_areset      (spi_filter_bmc_we_avmm_areset),                                      //            .areset
		.avm_address     (spi_filter_bmc_we_avmm_address),                                     //            .address
		.avm_waitrequest (spi_filter_bmc_we_avmm_waitrequest),                                 //            .waitrequest
		.avm_read        (spi_filter_bmc_we_avmm_read),                                        //            .read
		.avm_write       (spi_filter_bmc_we_avmm_write),                                       //            .write
		.avm_readdata    (spi_filter_bmc_we_avmm_readdata),                                    //            .readdata
		.avm_writedata   (spi_filter_bmc_we_avmm_writedata),                                   //            .writedata
		.avs_address     (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_address),     //        avmm.address
		.avs_waitrequest (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_waitrequest), //            .waitrequest
		.avs_read        (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_read),        //            .read
		.avs_write       (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_write),       //            .write
		.avs_readdata    (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_readdata),    //            .readdata
		.avs_writedata   (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_writedata)    //            .writedata
	);

	basic_avmm_bridge_rdv #(
		.ADDRESS_WIDTH (6)
	) u_spi_filter_csr_avmm_bridge_0 (
		.clk               (spi_clk_clk),                                                         //         clk.clk
		.areset            (spi_clk_reset_reset),                                                 //       reset.reset
		.avm_clk           (spi_filter_csr_avmm_clk),                                             // conduit_end.clk
		.avm_areset        (spi_filter_csr_avmm_areset),                                          //            .areset
		.avm_address       (spi_filter_csr_avmm_address),                                         //            .address
		.avm_waitrequest   (spi_filter_csr_avmm_waitrequest),                                     //            .waitrequest
		.avm_read          (spi_filter_csr_avmm_read),                                            //            .read
		.avm_write         (spi_filter_csr_avmm_write),                                           //            .write
		.avm_readdata      (spi_filter_csr_avmm_readdata),                                        //            .readdata
		.avm_writedata     (spi_filter_csr_avmm_writedata),                                       //            .writedata
		.avm_readdatavalid (spi_filter_csr_avmm_readdatavalid),                                   //            .readdatavalid
		.avs_address       (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_address),       //        avmm.address
		.avs_waitrequest   (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_waitrequest),   //            .waitrequest
		.avs_read          (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_read),          //            .read
		.avs_write         (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_write),         //            .write
		.avs_readdata      (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_readdata),      //            .readdata
		.avs_writedata     (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_writedata),     //            .writedata
		.avs_readdatavalid (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_readdatavalid)  //            .readdatavalid
	);

	basic_avmm_bridge #(
		.ADDRESS_WIDTH (11)
	) u_spi_filter_pch_we_avmm_bridge (
		.clk             (sys_clk_clk),                                                        //         clk.clk
		.areset          (rst_controller_reset_out_reset),                                     //       reset.reset
		.avm_clk         (spi_filter_pch_we_avmm_clk),                                         // conduit_end.clk
		.avm_areset      (spi_filter_pch_we_avmm_areset),                                      //            .areset
		.avm_address     (spi_filter_pch_we_avmm_address),                                     //            .address
		.avm_waitrequest (spi_filter_pch_we_avmm_waitrequest),                                 //            .waitrequest
		.avm_read        (spi_filter_pch_we_avmm_read),                                        //            .read
		.avm_write       (spi_filter_pch_we_avmm_write),                                       //            .write
		.avm_readdata    (spi_filter_pch_we_avmm_readdata),                                    //            .readdata
		.avm_writedata   (spi_filter_pch_we_avmm_writedata),                                   //            .writedata
		.avs_address     (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_address),     //        avmm.address
		.avs_waitrequest (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_waitrequest), //            .waitrequest
		.avs_read        (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_read),        //            .read
		.avs_write       (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_write),       //            .write
		.avs_readdata    (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_readdata),    //            .readdata
		.avs_writedata   (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_writedata)    //            .writedata
	);

	basic_avmm_bridge #(
		.ADDRESS_WIDTH (11)
	) u_timer_bank_avmm_bridge (
		.clk             (sys_clk_clk),                                                 //         clk.clk
		.areset          (rst_controller_reset_out_reset),                              //       reset.reset
		.avm_clk         (timer_bank_avmm_clk),                                         // conduit_end.clk
		.avm_areset      (timer_bank_avmm_areset),                                      //            .areset
		.avm_address     (timer_bank_avmm_address),                                     //            .address
		.avm_waitrequest (timer_bank_avmm_waitrequest),                                 //            .waitrequest
		.avm_read        (timer_bank_avmm_read),                                        //            .read
		.avm_write       (timer_bank_avmm_write),                                       //            .write
		.avm_readdata    (timer_bank_avmm_readdata),                                    //            .readdata
		.avm_writedata   (timer_bank_avmm_writedata),                                   //            .writedata
		.avs_address     (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_address),     //        avmm.address
		.avs_waitrequest (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_waitrequest), //            .waitrequest
		.avs_read        (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_read),        //            .read
		.avs_write       (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_write),       //            .write
		.avs_readdata    (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_readdata),    //            .readdata
		.avs_writedata   (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_writedata)    //            .writedata
	);

	altera_onchip_flash #(
		.INIT_FILENAME                       (""),
		.INIT_FILENAME_SIM                   (""),
		.DEVICE_FAMILY                       ("MAX 10"),
		.PART_NAME                           ("10M16SAU324I7G"),
		.DEVICE_ID                           ("16"),
		.SECTOR1_START_ADDR                  (0),
		.SECTOR1_END_ADDR                    (4095),
		.SECTOR2_START_ADDR                  (4096),
		.SECTOR2_END_ADDR                    (8191),
		.SECTOR3_START_ADDR                  (8192),
		.SECTOR3_END_ADDR                    (47103),
		.SECTOR4_START_ADDR                  (47104),
		.SECTOR4_END_ADDR                    (75775),
		.SECTOR5_START_ADDR                  (75776),
		.SECTOR5_END_ADDR                    (143359),
		.MIN_VALID_ADDR                      (0),
		.MAX_VALID_ADDR                      (143359),
		.MIN_UFM_VALID_ADDR                  (0),
		.MAX_UFM_VALID_ADDR                  (8191),
		.SECTOR1_MAP                         (1),
		.SECTOR2_MAP                         (2),
		.SECTOR3_MAP                         (3),
		.SECTOR4_MAP                         (4),
		.SECTOR5_MAP                         (5),
		.ADDR_RANGE1_END_ADDR                (143359),
		.ADDR_RANGE2_END_ADDR                (143359),
		.ADDR_RANGE1_OFFSET                  (1024),
		.ADDR_RANGE2_OFFSET                  (0),
		.ADDR_RANGE3_OFFSET                  (0),
		.AVMM_DATA_ADDR_WIDTH                (18),
		.AVMM_DATA_DATA_WIDTH                (32),
		.AVMM_DATA_BURSTCOUNT_WIDTH          (2),
		.SECTOR_READ_PROTECTION_MODE         (0),
		.FLASH_SEQ_READ_DATA_COUNT           (4),
		.FLASH_ADDR_ALIGNMENT_BITS           (2),
		.FLASH_READ_CYCLE_MAX_INDEX          (4),
		.FLASH_RESET_CYCLE_MAX_INDEX         (12),
		.FLASH_BUSY_TIMEOUT_CYCLE_MAX_INDEX  (60),
		.FLASH_ERASE_TIMEOUT_CYCLE_MAX_INDEX (17500000),
		.FLASH_WRITE_TIMEOUT_CYCLE_MAX_INDEX (15250),
		.PARALLEL_MODE                       (1),
		.READ_AND_WRITE_MODE                 (1),
		.WRAPPING_BURST_MODE                 (0),
		.IS_DUAL_BOOT                        ("True"),
		.IS_ERAM_SKIP                        ("True"),
		.IS_COMPRESSED_IMAGE                 ("True")
	) u_ufm (
		.clock                   (sys_clk_clk),                                //    clk.clk
		.reset_n                 (~rst_controller_reset_out_reset),            // nreset.reset_n
		.avmm_data_addr          (mm_interconnect_0_u_ufm_data_address),       //   data.address
		.avmm_data_read          (mm_interconnect_0_u_ufm_data_read),          //       .read
		.avmm_data_writedata     (mm_interconnect_0_u_ufm_data_writedata),     //       .writedata
		.avmm_data_write         (mm_interconnect_0_u_ufm_data_write),         //       .write
		.avmm_data_readdata      (mm_interconnect_0_u_ufm_data_readdata),      //       .readdata
		.avmm_data_waitrequest   (mm_interconnect_0_u_ufm_data_waitrequest),   //       .waitrequest
		.avmm_data_readdatavalid (mm_interconnect_0_u_ufm_data_readdatavalid), //       .readdatavalid
		.avmm_data_burstcount    (mm_interconnect_0_u_ufm_data_burstcount),    //       .burstcount
		.avmm_csr_addr           (mm_interconnect_0_u_ufm_csr_address),        //    csr.address
		.avmm_csr_read           (mm_interconnect_0_u_ufm_csr_read),           //       .read
		.avmm_csr_writedata      (mm_interconnect_0_u_ufm_csr_writedata),      //       .writedata
		.avmm_csr_write          (mm_interconnect_0_u_ufm_csr_write),          //       .write
		.avmm_csr_readdata       (mm_interconnect_0_u_ufm_csr_readdata)        //       .readdata
	);

	pfr_sys_mm_interconnect_0 mm_interconnect_0 (
		.u_spi_clk_out_clk_clk                                            (spi_clk_clk),                                                         //                                          u_spi_clk_out_clk.clk
		.u_sys_clk_out_clk_clk                                            (sys_clk_clk),                                                         //                                          u_sys_clk_out_clk.clk
		.u_nios_reset_reset_bridge_in_reset_reset                         (rst_controller_reset_out_reset),                                      //                         u_nios_reset_reset_bridge_in_reset.reset
		.u_spi_filter_csr_avmm_bridge_0_reset_reset_bridge_in_reset_reset (spi_clk_reset_reset),                                                 // u_spi_filter_csr_avmm_bridge_0_reset_reset_bridge_in_reset.reset
		.u_nios_data_master_address                                       (u_nios_data_master_address),                                          //                                         u_nios_data_master.address
		.u_nios_data_master_waitrequest                                   (u_nios_data_master_waitrequest),                                      //                                                           .waitrequest
		.u_nios_data_master_byteenable                                    (u_nios_data_master_byteenable),                                       //                                                           .byteenable
		.u_nios_data_master_read                                          (u_nios_data_master_read),                                             //                                                           .read
		.u_nios_data_master_readdata                                      (u_nios_data_master_readdata),                                         //                                                           .readdata
		.u_nios_data_master_write                                         (u_nios_data_master_write),                                            //                                                           .write
		.u_nios_data_master_writedata                                     (u_nios_data_master_writedata),                                        //                                                           .writedata
		.u_nios_data_master_debugaccess                                   (u_nios_data_master_debugaccess),                                      //                                                           .debugaccess
		.u_nios_instruction_master_address                                (u_nios_instruction_master_address),                                   //                                  u_nios_instruction_master.address
		.u_nios_instruction_master_waitrequest                            (u_nios_instruction_master_waitrequest),                               //                                                           .waitrequest
		.u_nios_instruction_master_read                                   (u_nios_instruction_master_read),                                      //                                                           .read
		.u_nios_instruction_master_readdata                               (u_nios_instruction_master_readdata),                                  //                                                           .readdata
		.u_crypto_avmm_bridge_avmm_address                                (mm_interconnect_0_u_crypto_avmm_bridge_avmm_address),                 //                                  u_crypto_avmm_bridge_avmm.address
		.u_crypto_avmm_bridge_avmm_write                                  (mm_interconnect_0_u_crypto_avmm_bridge_avmm_write),                   //                                                           .write
		.u_crypto_avmm_bridge_avmm_read                                   (mm_interconnect_0_u_crypto_avmm_bridge_avmm_read),                    //                                                           .read
		.u_crypto_avmm_bridge_avmm_readdata                               (mm_interconnect_0_u_crypto_avmm_bridge_avmm_readdata),                //                                                           .readdata
		.u_crypto_avmm_bridge_avmm_writedata                              (mm_interconnect_0_u_crypto_avmm_bridge_avmm_writedata),               //                                                           .writedata
		.u_crypto_avmm_bridge_avmm_waitrequest                            (mm_interconnect_0_u_crypto_avmm_bridge_avmm_waitrequest),             //                                                           .waitrequest
		.u_dual_config_avalon_address                                     (mm_interconnect_0_u_dual_config_avalon_address),                      //                                       u_dual_config_avalon.address
		.u_dual_config_avalon_write                                       (mm_interconnect_0_u_dual_config_avalon_write),                        //                                                           .write
		.u_dual_config_avalon_read                                        (mm_interconnect_0_u_dual_config_avalon_read),                         //                                                           .read
		.u_dual_config_avalon_readdata                                    (mm_interconnect_0_u_dual_config_avalon_readdata),                     //                                                           .readdata
		.u_dual_config_avalon_writedata                                   (mm_interconnect_0_u_dual_config_avalon_writedata),                    //                                                           .writedata
		.u_global_state_reg_s1_address                                    (mm_interconnect_0_u_global_state_reg_s1_address),                     //                                      u_global_state_reg_s1.address
		.u_global_state_reg_s1_write                                      (mm_interconnect_0_u_global_state_reg_s1_write),                       //                                                           .write
		.u_global_state_reg_s1_readdata                                   (mm_interconnect_0_u_global_state_reg_s1_readdata),                    //                                                           .readdata
		.u_global_state_reg_s1_writedata                                  (mm_interconnect_0_u_global_state_reg_s1_writedata),                   //                                                           .writedata
		.u_global_state_reg_s1_chipselect                                 (mm_interconnect_0_u_global_state_reg_s1_chipselect),                  //                                                           .chipselect
		.u_gpi_1_s1_address                                               (mm_interconnect_0_u_gpi_1_s1_address),                                //                                                 u_gpi_1_s1.address
		.u_gpi_1_s1_readdata                                              (mm_interconnect_0_u_gpi_1_s1_readdata),                               //                                                           .readdata
		.u_gpo_1_s1_address                                               (mm_interconnect_0_u_gpo_1_s1_address),                                //                                                 u_gpo_1_s1.address
		.u_gpo_1_s1_write                                                 (mm_interconnect_0_u_gpo_1_s1_write),                                  //                                                           .write
		.u_gpo_1_s1_readdata                                              (mm_interconnect_0_u_gpo_1_s1_readdata),                               //                                                           .readdata
		.u_gpo_1_s1_writedata                                             (mm_interconnect_0_u_gpo_1_s1_writedata),                              //                                                           .writedata
		.u_gpo_1_s1_chipselect                                            (mm_interconnect_0_u_gpo_1_s1_chipselect),                             //                                                           .chipselect
		.u_mailbox_avmm_bridge_avmm_address                               (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_address),                //                                 u_mailbox_avmm_bridge_avmm.address
		.u_mailbox_avmm_bridge_avmm_write                                 (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_write),                  //                                                           .write
		.u_mailbox_avmm_bridge_avmm_read                                  (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_read),                   //                                                           .read
		.u_mailbox_avmm_bridge_avmm_readdata                              (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_readdata),               //                                                           .readdata
		.u_mailbox_avmm_bridge_avmm_writedata                             (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_writedata),              //                                                           .writedata
		.u_mailbox_avmm_bridge_avmm_readdatavalid                         (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_readdatavalid),          //                                                           .readdatavalid
		.u_mailbox_avmm_bridge_avmm_waitrequest                           (mm_interconnect_0_u_mailbox_avmm_bridge_avmm_waitrequest),            //                                                           .waitrequest
		.u_nios_debug_mem_slave_address                                   (mm_interconnect_0_u_nios_debug_mem_slave_address),                    //                                     u_nios_debug_mem_slave.address
		.u_nios_debug_mem_slave_write                                     (mm_interconnect_0_u_nios_debug_mem_slave_write),                      //                                                           .write
		.u_nios_debug_mem_slave_read                                      (mm_interconnect_0_u_nios_debug_mem_slave_read),                       //                                                           .read
		.u_nios_debug_mem_slave_readdata                                  (mm_interconnect_0_u_nios_debug_mem_slave_readdata),                   //                                                           .readdata
		.u_nios_debug_mem_slave_writedata                                 (mm_interconnect_0_u_nios_debug_mem_slave_writedata),                  //                                                           .writedata
		.u_nios_debug_mem_slave_byteenable                                (mm_interconnect_0_u_nios_debug_mem_slave_byteenable),                 //                                                           .byteenable
		.u_nios_debug_mem_slave_waitrequest                               (mm_interconnect_0_u_nios_debug_mem_slave_waitrequest),                //                                                           .waitrequest
		.u_nios_debug_mem_slave_debugaccess                               (mm_interconnect_0_u_nios_debug_mem_slave_debugaccess),                //                                                           .debugaccess
		.u_nios_ram_s1_address                                            (mm_interconnect_0_u_nios_ram_s1_address),                             //                                              u_nios_ram_s1.address
		.u_nios_ram_s1_write                                              (mm_interconnect_0_u_nios_ram_s1_write),                               //                                                           .write
		.u_nios_ram_s1_readdata                                           (mm_interconnect_0_u_nios_ram_s1_readdata),                            //                                                           .readdata
		.u_nios_ram_s1_writedata                                          (mm_interconnect_0_u_nios_ram_s1_writedata),                           //                                                           .writedata
		.u_nios_ram_s1_byteenable                                         (mm_interconnect_0_u_nios_ram_s1_byteenable),                          //                                                           .byteenable
		.u_nios_ram_s1_chipselect                                         (mm_interconnect_0_u_nios_ram_s1_chipselect),                          //                                                           .chipselect
		.u_nios_ram_s1_clken                                              (mm_interconnect_0_u_nios_ram_s1_clken),                               //                                                           .clken
		.u_relay1_avmm_bridge_avmm_address                                (mm_interconnect_0_u_relay1_avmm_bridge_avmm_address),                 //                                  u_relay1_avmm_bridge_avmm.address
		.u_relay1_avmm_bridge_avmm_write                                  (mm_interconnect_0_u_relay1_avmm_bridge_avmm_write),                   //                                                           .write
		.u_relay1_avmm_bridge_avmm_read                                   (mm_interconnect_0_u_relay1_avmm_bridge_avmm_read),                    //                                                           .read
		.u_relay1_avmm_bridge_avmm_readdata                               (mm_interconnect_0_u_relay1_avmm_bridge_avmm_readdata),                //                                                           .readdata
		.u_relay1_avmm_bridge_avmm_writedata                              (mm_interconnect_0_u_relay1_avmm_bridge_avmm_writedata),               //                                                           .writedata
		.u_relay1_avmm_bridge_avmm_waitrequest                            (mm_interconnect_0_u_relay1_avmm_bridge_avmm_waitrequest),             //                                                           .waitrequest
		.u_relay2_avmm_bridge_avmm_address                                (mm_interconnect_0_u_relay2_avmm_bridge_avmm_address),                 //                                  u_relay2_avmm_bridge_avmm.address
		.u_relay2_avmm_bridge_avmm_write                                  (mm_interconnect_0_u_relay2_avmm_bridge_avmm_write),                   //                                                           .write
		.u_relay2_avmm_bridge_avmm_read                                   (mm_interconnect_0_u_relay2_avmm_bridge_avmm_read),                    //                                                           .read
		.u_relay2_avmm_bridge_avmm_readdata                               (mm_interconnect_0_u_relay2_avmm_bridge_avmm_readdata),                //                                                           .readdata
		.u_relay2_avmm_bridge_avmm_writedata                              (mm_interconnect_0_u_relay2_avmm_bridge_avmm_writedata),               //                                                           .writedata
		.u_relay2_avmm_bridge_avmm_waitrequest                            (mm_interconnect_0_u_relay2_avmm_bridge_avmm_waitrequest),             //                                                           .waitrequest
		.u_relay3_avmm_bridge_avmm_address                                (mm_interconnect_0_u_relay3_avmm_bridge_avmm_address),                 //                                  u_relay3_avmm_bridge_avmm.address
		.u_relay3_avmm_bridge_avmm_write                                  (mm_interconnect_0_u_relay3_avmm_bridge_avmm_write),                   //                                                           .write
		.u_relay3_avmm_bridge_avmm_read                                   (mm_interconnect_0_u_relay3_avmm_bridge_avmm_read),                    //                                                           .read
		.u_relay3_avmm_bridge_avmm_readdata                               (mm_interconnect_0_u_relay3_avmm_bridge_avmm_readdata),                //                                                           .readdata
		.u_relay3_avmm_bridge_avmm_writedata                              (mm_interconnect_0_u_relay3_avmm_bridge_avmm_writedata),               //                                                           .writedata
		.u_relay3_avmm_bridge_avmm_waitrequest                            (mm_interconnect_0_u_relay3_avmm_bridge_avmm_waitrequest),             //                                                           .waitrequest
		.u_rfnvram_smbus_master_avmm_address                              (mm_interconnect_0_u_rfnvram_smbus_master_avmm_address),               //                                u_rfnvram_smbus_master_avmm.address
		.u_rfnvram_smbus_master_avmm_write                                (mm_interconnect_0_u_rfnvram_smbus_master_avmm_write),                 //                                                           .write
		.u_rfnvram_smbus_master_avmm_read                                 (mm_interconnect_0_u_rfnvram_smbus_master_avmm_read),                  //                                                           .read
		.u_rfnvram_smbus_master_avmm_readdata                             (mm_interconnect_0_u_rfnvram_smbus_master_avmm_readdata),              //                                                           .readdata
		.u_rfnvram_smbus_master_avmm_writedata                            (mm_interconnect_0_u_rfnvram_smbus_master_avmm_writedata),             //                                                           .writedata
		.u_rfnvram_smbus_master_avmm_readdatavalid                        (mm_interconnect_0_u_rfnvram_smbus_master_avmm_readdatavalid),         //                                                           .readdatavalid
		.u_rfnvram_smbus_master_avmm_waitrequest                          (mm_interconnect_0_u_rfnvram_smbus_master_avmm_waitrequest),           //                                                           .waitrequest
		.u_spi_filter_avmm_bridge_avmm_address                            (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_address),             //                              u_spi_filter_avmm_bridge_avmm.address
		.u_spi_filter_avmm_bridge_avmm_write                              (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_write),               //                                                           .write
		.u_spi_filter_avmm_bridge_avmm_read                               (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_read),                //                                                           .read
		.u_spi_filter_avmm_bridge_avmm_readdata                           (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_readdata),            //                                                           .readdata
		.u_spi_filter_avmm_bridge_avmm_writedata                          (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_writedata),           //                                                           .writedata
		.u_spi_filter_avmm_bridge_avmm_readdatavalid                      (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_readdatavalid),       //                                                           .readdatavalid
		.u_spi_filter_avmm_bridge_avmm_waitrequest                        (mm_interconnect_0_u_spi_filter_avmm_bridge_avmm_waitrequest),         //                                                           .waitrequest
		.u_spi_filter_bmc_we_avmm_bridge_avmm_address                     (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_address),      //                       u_spi_filter_bmc_we_avmm_bridge_avmm.address
		.u_spi_filter_bmc_we_avmm_bridge_avmm_write                       (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_write),        //                                                           .write
		.u_spi_filter_bmc_we_avmm_bridge_avmm_read                        (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_read),         //                                                           .read
		.u_spi_filter_bmc_we_avmm_bridge_avmm_readdata                    (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_readdata),     //                                                           .readdata
		.u_spi_filter_bmc_we_avmm_bridge_avmm_writedata                   (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_writedata),    //                                                           .writedata
		.u_spi_filter_bmc_we_avmm_bridge_avmm_waitrequest                 (mm_interconnect_0_u_spi_filter_bmc_we_avmm_bridge_avmm_waitrequest),  //                                                           .waitrequest
		.u_spi_filter_csr_avmm_bridge_0_avmm_address                      (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_address),       //                        u_spi_filter_csr_avmm_bridge_0_avmm.address
		.u_spi_filter_csr_avmm_bridge_0_avmm_write                        (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_write),         //                                                           .write
		.u_spi_filter_csr_avmm_bridge_0_avmm_read                         (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_read),          //                                                           .read
		.u_spi_filter_csr_avmm_bridge_0_avmm_readdata                     (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_readdata),      //                                                           .readdata
		.u_spi_filter_csr_avmm_bridge_0_avmm_writedata                    (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_writedata),     //                                                           .writedata
		.u_spi_filter_csr_avmm_bridge_0_avmm_readdatavalid                (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_readdatavalid), //                                                           .readdatavalid
		.u_spi_filter_csr_avmm_bridge_0_avmm_waitrequest                  (mm_interconnect_0_u_spi_filter_csr_avmm_bridge_0_avmm_waitrequest),   //                                                           .waitrequest
		.u_spi_filter_pch_we_avmm_bridge_avmm_address                     (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_address),      //                       u_spi_filter_pch_we_avmm_bridge_avmm.address
		.u_spi_filter_pch_we_avmm_bridge_avmm_write                       (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_write),        //                                                           .write
		.u_spi_filter_pch_we_avmm_bridge_avmm_read                        (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_read),         //                                                           .read
		.u_spi_filter_pch_we_avmm_bridge_avmm_readdata                    (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_readdata),     //                                                           .readdata
		.u_spi_filter_pch_we_avmm_bridge_avmm_writedata                   (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_writedata),    //                                                           .writedata
		.u_spi_filter_pch_we_avmm_bridge_avmm_waitrequest                 (mm_interconnect_0_u_spi_filter_pch_we_avmm_bridge_avmm_waitrequest),  //                                                           .waitrequest
		.u_timer_bank_avmm_bridge_avmm_address                            (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_address),             //                              u_timer_bank_avmm_bridge_avmm.address
		.u_timer_bank_avmm_bridge_avmm_write                              (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_write),               //                                                           .write
		.u_timer_bank_avmm_bridge_avmm_read                               (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_read),                //                                                           .read
		.u_timer_bank_avmm_bridge_avmm_readdata                           (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_readdata),            //                                                           .readdata
		.u_timer_bank_avmm_bridge_avmm_writedata                          (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_writedata),           //                                                           .writedata
		.u_timer_bank_avmm_bridge_avmm_waitrequest                        (mm_interconnect_0_u_timer_bank_avmm_bridge_avmm_waitrequest),         //                                                           .waitrequest
		.u_ufm_csr_address                                                (mm_interconnect_0_u_ufm_csr_address),                                 //                                                  u_ufm_csr.address
		.u_ufm_csr_write                                                  (mm_interconnect_0_u_ufm_csr_write),                                   //                                                           .write
		.u_ufm_csr_read                                                   (mm_interconnect_0_u_ufm_csr_read),                                    //                                                           .read
		.u_ufm_csr_readdata                                               (mm_interconnect_0_u_ufm_csr_readdata),                                //                                                           .readdata
		.u_ufm_csr_writedata                                              (mm_interconnect_0_u_ufm_csr_writedata),                               //                                                           .writedata
		.u_ufm_data_address                                               (mm_interconnect_0_u_ufm_data_address),                                //                                                 u_ufm_data.address
		.u_ufm_data_write                                                 (mm_interconnect_0_u_ufm_data_write),                                  //                                                           .write
		.u_ufm_data_read                                                  (mm_interconnect_0_u_ufm_data_read),                                   //                                                           .read
		.u_ufm_data_readdata                                              (mm_interconnect_0_u_ufm_data_readdata),                               //                                                           .readdata
		.u_ufm_data_writedata                                             (mm_interconnect_0_u_ufm_data_writedata),                              //                                                           .writedata
		.u_ufm_data_burstcount                                            (mm_interconnect_0_u_ufm_data_burstcount),                             //                                                           .burstcount
		.u_ufm_data_readdatavalid                                         (mm_interconnect_0_u_ufm_data_readdatavalid),                          //                                                           .readdatavalid
		.u_ufm_data_waitrequest                                           (mm_interconnect_0_u_ufm_data_waitrequest)                             //                                                           .waitrequest
	);

	pfr_sys_irq_mapper irq_mapper (
		.clk        (sys_clk_clk),                    //       clk.clk
		.reset      (rst_controller_reset_out_reset), // clk_reset.reset
		.sender_irq (u_nios_irq_irq)                  //    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (sys_clk_reset_reset),                // reset_in0.reset
		.clk            (sys_clk_clk),                        //       clk.clk
		.reset_out      (rst_controller_reset_out_reset),     // reset_out.reset
		.reset_req      (rst_controller_reset_out_reset_req), //          .reset_req
		.reset_req_in0  (1'b0),                               // (terminated)
		.reset_in1      (1'b0),                               // (terminated)
		.reset_req_in1  (1'b0),                               // (terminated)
		.reset_in2      (1'b0),                               // (terminated)
		.reset_req_in2  (1'b0),                               // (terminated)
		.reset_in3      (1'b0),                               // (terminated)
		.reset_req_in3  (1'b0),                               // (terminated)
		.reset_in4      (1'b0),                               // (terminated)
		.reset_req_in4  (1'b0),                               // (terminated)
		.reset_in5      (1'b0),                               // (terminated)
		.reset_req_in5  (1'b0),                               // (terminated)
		.reset_in6      (1'b0),                               // (terminated)
		.reset_req_in6  (1'b0),                               // (terminated)
		.reset_in7      (1'b0),                               // (terminated)
		.reset_req_in7  (1'b0),                               // (terminated)
		.reset_in8      (1'b0),                               // (terminated)
		.reset_req_in8  (1'b0),                               // (terminated)
		.reset_in9      (1'b0),                               // (terminated)
		.reset_req_in9  (1'b0),                               // (terminated)
		.reset_in10     (1'b0),                               // (terminated)
		.reset_req_in10 (1'b0),                               // (terminated)
		.reset_in11     (1'b0),                               // (terminated)
		.reset_req_in11 (1'b0),                               // (terminated)
		.reset_in12     (1'b0),                               // (terminated)
		.reset_req_in12 (1'b0),                               // (terminated)
		.reset_in13     (1'b0),                               // (terminated)
		.reset_req_in13 (1'b0),                               // (terminated)
		.reset_in14     (1'b0),                               // (terminated)
		.reset_req_in14 (1'b0),                               // (terminated)
		.reset_in15     (1'b0),                               // (terminated)
		.reset_req_in15 (1'b0)                                // (terminated)
	);

endmodule
