`timescale 1 ps / 1 ps
`default_nettype none


module basic_avmm_bridge #(
    ADDRESS_WIDTH = 1
) (
    input wire clk,
    input wire areset,
    
    input wire [ADDRESS_WIDTH-1:0] avs_address,
    output wire avs_waitrequest,
    input wire avs_read,
    input wire avs_write,
    output wire [31:0] avs_readdata,
    input wire [31:0] avs_writedata,
    
    output wire avm_clk,
    output wire avm_areset,
    output wire [ADDRESS_WIDTH-1:0] avm_address,
    input wire avm_waitrequest,
    output wire avm_read,
    output wire avm_write,
    input wire [31:0] avm_readdata,
    output wire [31:0] avm_writedata

);


    assign avm_clk = clk;
    assign avm_areset = areset;
    assign avm_address = avs_address;
    assign avs_waitrequest = avm_waitrequest;
    assign avm_read = avs_read;
    assign avm_write = avs_write;
    assign avs_readdata = avm_readdata;
    assign avm_writedata = avs_writedata;


endmodule